#ifndef __BVH_H
#define __BVH_H

#include "../common/SimpleBoundingBox.h"
#include "../Primitives/PrimitiveBase.h"
#include "../Primitives/AABB.h"
#include "../Hierarchy/HierarchyBase.h"
#include "../Hierarchy/SplitSelection.h"

class BVHNode : public SimpleBoundingBox
{
public:
	enum nodeType {internal, leaf};
	nodeType type;
	
	BVHNode()
	{
		type = BVHNode::internal;
		this->primitivePtr = NULL;
		this->leftNode = NULL;
		this->rightNode = NULL;
	}
	
	~BVHNode()
	{ }


	#define numDimen 3
	inline slimFloat minf(const slimFloat a, const slimFloat b)
	{ return a < b ? a : b; }
	inline slimFloat maxf(const slimFloat a, const slimFloat b)
	{ return a > b ? a : b; }
	
	void setLeft(BVHNode* n)
	{ leftNode = n; }
	
	void setRight(BVHNode* n)
	{ rightNode = n; }
	
	void setPrimitive(PrimitiveBase* p)
	{ primitivePtr = p; }
	
	BVHNode* getLeft()
	{ return leftNode; }
	
	BVHNode* getRight()
	{ return rightNode; }
	
	PrimitiveBase* getPrimitive()
	{ return primitivePtr; }
private:
	BVHNode* leftNode;
	BVHNode* rightNode;
	PrimitiveBase* primitivePtr;
};

class BVH : public HierarchyBase
{
public:
	BVHNode *rootNode;
	
	BVH()
	{ rootNode = NULL;}
	
	~BVH()
	{ rootNode = NULL;}
	
	virtual void build(PrimitivePtrList &pList);
	virtual bool rayIntersectAll(const Ray &r, HitPoint &h);
	virtual bool rayIntersectSingle(const Ray &r, HitPoint &h);
private:
	#define SplitterType SAH
	//#define SplitterType SpatialMedian
	//#define SplitterType ObjectMedian
	SplitterType *splitter;
	PrimitivePtrList primitives;
	//void fillNode(BVHNode *n, PrimitivePtrList &pList);
	void fillNode(BVHNode *n, int leftIndex, int rightIndex);
	bool intersectNode(BVHNode *rootNode, const Ray &r, HitPoint &h);
};

#endif
