#include "../common/Common.h"
#include "FlatList.h"


void FlatList::build(PrimitivePtrList &pList)
{	
	for(unsigned int i=0; i < pList.size(); i++)
	{
		primitives.push_back(pList[i]);
		this->box.encompass(pList[i]->bbMin, pList[i]->bbMax);
	}
}

bool FlatList::outOfDate()
{ return false; }

void FlatList::update()
{ }

void FlatList::add(const PrimitiveBase &p)
{
}

void FlatList::remove(const PrimitiveBase &p)
{
}

bool FlatList::rayIntersectAll(const Ray &r, HitPoint &h)
{
	if( !box.rayIntersect(r, h) )
		return false;
	
	bool hitSomething;
	bool atLeastOneHit = false;
	h.primitivePtr = NULL;

	for(unsigned int i=0; i < primitives.size(); i++)
	{
		hitSomething = primitives[i]->rayIntersect((Ray&)r, h);
		
		if(hitSomething)
		{
			atLeastOneHit = true;
			h.pos = r.parameter(h.distance);
			h.primitivePtr = primitives[i];
		}
	}
	
	return atLeastOneHit;
}

bool FlatList::rayIntersectSingle(const Ray &r, HitPoint &h)
{
	bool hitSomething;
//	intersects_calced++;
	
	if(h.primitivePtr->rayIntersect(r, h) && h.distance > EPSILON )
	{
		//h.distance = hitSomething;
		return true;
	}
	
	return false;
}
