#ifndef __HIERARCHY_H
#define __HIERARCHY_H

#include "../common/Common.h"
#include "../common/Vector3.h"
#include "../Primitives/PrimitiveBase.h"
#include "../Primitives/AABB.h"

#define MAX_BVH_STACK_SIZE 80
template <class T>
class SimpleStack
{
public:
	SimpleStack() { numNodes = 0; }
	
	void push(const T n) { stack[numNodes] = n; numNodes++; }
	
	T pop() { return stack[--numNodes]; }
	
	bool notEmpty() const { return numNodes > 0; }
	
	void swapTopElements()
	{
		T tmp;
		const int topNode = numNodes-1;
		const int almostTopNode = numNodes-2;
		tmp = stack[topNode];
		stack[topNode] = stack[almostTopNode];
		stack[almostTopNode] = tmp;
	}
	
private:
	int numNodes;
	T stack[MAX_BVH_STACK_SIZE];
};


class HierarchyBase
{
public:
	AABB box;
	
	HierarchyBase()
	{
		this->box.bbMin = vector3(maxFloat,maxFloat,maxFloat);
		this->box.bbMax = vector3(minFloat,minFloat,minFloat);
	}
	
	virtual void build(PrimitivePtrList &pList) { }
	virtual slimFloat size() { return (this->box.bbMax - this->box.bbMin).length(); }
	virtual bool outOfDate() { return false; }
	virtual void update() { }
	virtual void add(const PrimitiveBase &p) { }
	virtual void remove(const PrimitiveBase &p) { }
	virtual bool rayIntersectAll(const Ray &r, HitPoint &h) { return false; }
	virtual bool rayIntersectSingle(const Ray &r, HitPoint &h) { return false; }
};

#endif
