#ifndef __SKIPBVH_H
#define __SKIPBVH_H

#include "../common/SimpleBoundingBox.h"
#include "../Primitives/PrimitiveBase.h"
#include "../Primitives/AABB.h"
#include "../Hierarchy/HierarchyBase.h"
#include "../Hierarchy/SplitSelection.h"

class SkipBVHNode : public SimpleBoundingBox
{
	// Described in "Efficiency Issues for Ray Tracing", Smit 1998
public:
	enum nodeType {internal, leaf};
	
	SkipBVHNode()
	{
		this->primitive = NULL;
		this->nextNode = NULL;
	}
	
	~SkipBVHNode()
	{
		//free(children);
	}
	
	inline slimFloat minf(const slimFloat a, const slimFloat b)
	{ return a < b ? a : b; }
	inline slimFloat maxf(const slimFloat a, const slimFloat b)
	{ return a > b ? a : b; }
	
	inline SkipBVHNode* getLeft()
	{
		SkipBVHNode* leftNode = this;
		leftNode++;
		return leftNode;
	}
	
	inline SkipBVHNode* getRight()
	{ return this->nextNode; }

	void setLeft(SkipBVHNode* n)
	{ printf("Can't set left node in skip tree!\n"); return; }
	
	void setRight(SkipBVHNode* n)
	{ this->nextNode = n; }
	
	void setPrimitive(PrimitiveBase* p)
	{ this->primitive = p; }
	
	PrimitiveBase* getPrimitive()
	{ return this->primitive; }
	
	nodeType getType()
	{
		if(this->primitive == NULL)
			return internal;
		return leaf;
	}
	
private:
	PrimitiveBase* primitive;
	SkipBVHNode* nextNode;
};

class SkipBVH : public HierarchyBase
{
public:
	SkipBVHNode *nodes;
	
	SkipBVH()
	{
		nodePos = 0;
		printf("BVH node size: %i\n", sizeof(SkipBVHNode));
	}
	
	virtual void build(PrimitivePtrList &pList);
	virtual bool rayIntersectAll(const Ray &r, HitPoint &h);
	virtual bool rayIntersectSingle(const Ray &r, HitPoint &h);
private:
	int nodePos;
	#define SplitterType SAH
	//#define SplitterType SpatialMedian
	//#define SplitterType ObjectMedian
	SplitterType *splitter;
	SkipBVHNode *stopNode;
	PrimitivePtrList primitives;
	
	SkipBVHNode* getNextNodeFromList();
	SkipBVHNode* getSkipNode(SkipBVHNode* currentNode, int numToSkip);
	bool intersectNodesFlat(SkipBVHNode *rootNode, const Ray &r, HitPoint &h);
	bool intersectNodesStack(SkipBVHNode *rootNode, const Ray &r, HitPoint &h);
	void fillNode(SkipBVHNode *n, SkipBVHNode* nextNode, int leftIndex, int rightIndex);
};

#endif
