#ifndef __STACKBVH_H
#define __STACKBVH_H

#include "../common/SimpleBoundingBox.h"
#include "../Primitives/PrimitiveBase.h"
#include "../Primitives/AABB.h"
#include "../Hierarchy/HierarchyBase.h"
#include "../Hierarchy/SplitSelection.h"

class StackBVHNode : public SimpleBoundingBox
{
public:
	enum nodeType {internal, leaf};
	
	StackBVHNode()
	{
		nodeData[0] = 0; nodeData[1] = 0; nodeData[2] = 0; nodeData[3] = 0; 
		this->nextNode = NULL;
	}
	
	~StackBVHNode()
	{
		//free(children);
	}
	
	inline slimFloat minf(const slimFloat a, const slimFloat b)
	{ return a < b ? a : b; }
	inline slimFloat maxf(const slimFloat a, const slimFloat b)
	{ return a > b ? a : b; }
	
	inline StackBVHNode* getLeft()
	{
		return (StackBVHNode*) this->nextNode;
	}
	
	inline StackBVHNode* getRight()
	{
		StackBVHNode* leftNode = (StackBVHNode*) this->nextNode;
		leftNode++; // now right node
		return leftNode;
	}
	
	void setLeft(StackBVHNode* n)
	{ this->nextNode = (void*) n; }
	
	void setRight(StackBVHNode* n)
	{ /*this->nextNode = (void*) n;*/ }
	
	void setPrimitive(PrimitiveBase* p)
	{
		this->nodeData[0] = 1;
		this->nextNode = (void*) p;
	}
	
	void setAxis(char axis)
	{ this->nodeData[2] = axis; }
	
	char getAxis()
	{ return this->nodeData[2]; }
	
	PrimitiveBase* getPrimitive()
	{ return (PrimitiveBase*) this->nextNode; }
	
	bool isInternalNode()
	{
		if(this->nodeData[0] == 0)
			return true;
		return false;
	}
	
private:
	char nodeData[4];
	void* nextNode;
};

class StackBVH : public HierarchyBase
{
public:
	StackBVHNode *nodes;
	
	StackBVH()
	{
		nodePos = 0;
		printf("BVH node size: %i\n", sizeof(StackBVHNode));
	}
	
	virtual void build(PrimitivePtrList &pList);
	virtual bool rayIntersectAll(const Ray &r, HitPoint &h);
	virtual bool rayIntersectSingle(const Ray &r, HitPoint &h);
private:
	int nodePos;
	#define SplitterType SAH
	//#define SplitterType SpatialMedian
	//#define SplitterType ObjectMedian
	SplitterType *splitter;
	StackBVHNode *stopNode;
	PrimitivePtrList primitives;
	
	StackBVHNode* getNextNodeFromList();
	StackBVHNode* getSkipNode(StackBVHNode* currentNode, int numToSkip);
	bool intersectNodesFlat(StackBVHNode *rootNode, const Ray &r, HitPoint &h);
	bool intersectNodesStack(StackBVHNode *rootNode, const Ray &r, HitPoint &h);
	void fillNode(StackBVHNode *n, int leftIndex, int rightIndex);
};

#endif
