#include <math.h>
#include <stdio.h>
#include "../Primitives/PrimitiveBase.h"
#include "../common/Vector3.h"
//#include "../render/vector.c"
#include "Disc.h"

extern SlimScene* main_scene;




slimFloat Disc::rayIntersect(const vector3 &startP, const vector3 &projV, vector3 &pntIntersect)
{
	float normDproj;
	float normDvec;
	float intersectDist;
vector3 normV;
vector3 planeV;
vector3 hit_point;

	// get the plane's normal vector
	normV.c[0] = this->norm.c[0];
	normV.c[1] = this->norm.c[1];
	normV.c[2] = this->norm.c[2];

//	printd(2,"pln: %f, %f, %f\n", plane->norm.c[0], plane->norm.c[1], plane->norm.c[2]);
//	printd(2,"srt: %f, %f, %f\n", startP.c[0], startP.c[1], startP.c[2]);
//	printd(2,"prj: %f, %f, %f\n", projV.c[0], projV.c[1], projV.c[2]);
//	exit(1);

	// normal dot projection
	normDproj = normV.dot( projV);

	// if normDproj is 0, the ray is parallel to the plane, so we stop
	if(normDproj == 0)
		return 0;

	// finish the calc if not parallel
	// get the vector from the plane to the camera
	planeV.c[0] = this->pos.c[0] - startP.c[0];
	planeV.c[1] = this->pos.c[1] - startP.c[1];
	planeV.c[2] = this->pos.c[2] - startP.c[2];

	// normal dot vector to plane
	normDvec = normV.dot( planeV);

	// if normDvec is negative it's behind the camera
	//if( normDvec < 0)
	//   return 0;

	// intersection is at normDvec / normDproj
	intersectDist = normDvec / normDproj;

	if(intersectDist < 0 )
		return 0;

	hit_point.c[0] = startP.c[0] + projV.c[0]*intersectDist;
	hit_point.c[1] = startP.c[1] + projV.c[1]*intersectDist;
	hit_point.c[2] = startP.c[2] + projV.c[2]*intersectDist;

	//printd(2,"intersected a plane\n");
	//return 1;
	if( hit_point.distance(this->pos) > this->radius)
		return 0;

	return intersectDist;
}

/*****************************************************
 Calculates the normalvector3 at a point, on an Primitive
 *****************************************************/
vector3 Disc::normalAtPoint(const vector3 &p)
{
	vector3 n;
	n.c[0] = this->norm.c[0];
	n.c[1] = this->norm.c[1];
	n.c[2] = this->norm.c[2];
	return n;
}

