#include <math.h>
#include <stdio.h>
#include <time.h>
#include "../Primitives/PrimitiveBase.h"
#include "../common/scene.h"
#include "../common/Vector3.h"
#include "../common/misc.h"
#include "../common/debug.h"
//#include "../render/vector.c"
#include "../parse/parser.h"
#include "../shader/shaders.h"
#include "Plane.h"
#include "LineSegment.h"
#include "../common/string_extra.h"

//#include <pthread.h>
//extern pthread_mutex_t mutexor;
extern SlimScene* main_scene;

//
// From: http://local.wasp.uwa.edu.au/~pbourke/geometry/lineline3d/
//
//float line_segment_intersect(vector3& origin, vector3& projection, PrimitiveBase* obj,	vector3& old_intersection)
slimFloat LineSegment::rayIntersect(const vector3 &origin, const vector3 &projection, vector3 &intersectPoint)
{
	/*
	Calculate the line segment PaPb that is the shortest route between
	 two lines P1P2 and P3P4. Calculate also the values of mua and mub where
	 Pa = P1 + mua (P2 - P1)
	 Pb = P3 + mub (P4 - P3)
	 Return FALSE if no solution exists.
	 */

	// p1,p2 is the ray     p3, p4 is the defined line segment
	vector3 p1, p2, p3, p4;
	vector3 pa, pb;
	vector3 p13,p43,p21;
	float d1343,d4321,d1321,d4343,d2121;
	float numer,denom;
	float mua, mub;
	
	vector3 proj;
	float distance;
	
	
	//setup p1, p2
	p1 = vector3(origin);
	p2 = projection * 99999;
	p2 = p1 + p2;
	
	//setup p3, p4
	p3 = vector3(this->pos);
	p4 = this->norm *  this->length;
	p4 = p3 + p4;
					 
	p13.c[0] = p1.c[0] - p3.c[0];
	p13.c[1] = p1.c[1] - p3.c[1];
	p13.c[2] = p1.c[2] - p3.c[2];
	p43.c[0] = p4.c[0] - p3.c[0];
	p43.c[1] = p4.c[1] - p3.c[1];
	p43.c[2] = p4.c[2] - p3.c[2];
	if (fabs(p43.c[0])  < EPSILON && fabs(p43.c[1])  < EPSILON && fabs(p43.c[2])  < EPSILON)
		return(0);
	p21.c[0] = p2.c[0] - p1.c[0];
	p21.c[1] = p2.c[1] - p1.c[1];
	p21.c[2] = p2.c[2] - p1.c[2];
	if (fabs(p21.c[0])  < EPSILON && fabs(p21.c[1])  < EPSILON && fabs(p21.c[2])  < EPSILON)
		return(0);
	
	d1343 = p13.c[0] * p43.c[0] + p13.c[1] * p43.c[1] + p13.c[2] * p43.c[2];
	d4321 = p43.c[0] * p21.c[0] + p43.c[1] * p21.c[1] + p43.c[2] * p21.c[2];
	d1321 = p13.c[0] * p21.c[0] + p13.c[1] * p21.c[1] + p13.c[2] * p21.c[2];
	d4343 = p43.c[0] * p43.c[0] + p43.c[1] * p43.c[1] + p43.c[2] * p43.c[2];
	d2121 = p21.c[0] * p21.c[0] + p21.c[1] * p21.c[1] + p21.c[2] * p21.c[2];
	
	denom = d2121 * d4343 - d4321 * d4321;
	if (fabs(denom) < EPSILON)
		return(0);
	numer = d1343 * d4321 - d1321 * d4343;
	
	mua = numer / denom;
	mub = (d1343 + d4321 * (mua)) / d4343;

	//no lines behind camera
	if(mua < 0)
		return 0;
	
	//can't go backwards on line
	if(mub < 0)
		return 0;
	
	//stop at end of segment
	proj = p43 * mub;
	distance = proj.length();
	if(distance > this->length)
		return 0;
	
	pa.c[0] = p1.c[0] + mua * p21.c[0];
	pa.c[1] = p1.c[1] + mua * p21.c[1];
	pa.c[2] = p1.c[2] + mua * p21.c[2];
	pb.c[0] = p3.c[0] + mub * p43.c[0];
	pb.c[1] = p3.c[1] + mub * p43.c[1];
	pb.c[2] = p3.c[2] + mub * p43.c[2];
	
	proj = p21 * mua;
	distance = proj.length();
	
	//scaling independent size
	if( pa.distance(pb) < distance * 0.002 )
		return(distance);
	
	return 0;
}

vector3 LineSegment::normalAtPoint(const vector3 &p)
//vector3 line_segment_normal(vector3& q, PrimitiveBase* PrimitiveHit, vector3& n)
{
	vector3 n;
	n.c[0] = 1;
	n.c[1] = 1;
	n.c[2] = 1;
	return n;
}

/*
PrimitiveBase *line_segment_create(int obj_number)
{
	PrimitiveBase* obj;
	obj = (PrimitiveBase*) (malloc (sizeof(Primitive)));
	
	obj->obj_type = LINE_SEGMENT;
	obj->id = obj_number;
	obj->data = malloc( sizeof(line_segment_data) );
	//obj->intersect =  (float (*)(vector3&, vector3&, void*, vector3&))&line_segment_intersect;
	//obj->normal =  (vector3 (*)(vector3&, void*, vector3&))&line_segment_normal;
	
	obj->pos = vector3(0, 0, 0);
	make_color(&obj->amb, 100, 100, 100);
	make_color(&obj->spec, 0, 0, 0);
	make_color(&obj->diff, 200, 200, 200);
	obj->norm = vector3(1, 0, 0);
	obj->up = vector3(0, 1, 0);
	obj->setMisc(0, 0, 0, 0, 0);
	obj->collided = 0;
	
	obj->shader = (void* (*)(void*, color*)) general_shader;
	obj->no_shadow = 1;
	
	return obj;
}*/

/*
void line_segment_from_points(PrimitiveBase *obj,vector3 *vertices[4])
{

}
*/

void LineSegment::setup()
{
	if(this->radius > 0)
	{
		this->length =  this->radius;
		this->norm.normalize();
	}
	else
	{
		this->norm = this->norm - this->pos;
		this->length =  this->norm.length();
		this->norm.normalize();
	}
}

/*
void line_segment_set(PrimitiveBase *obj, char *key, char *value)
{
	line_segment_data *obj_data = (line_segment_data*) obj->data;
	
	if( strequal(key, "length") )
		assign_float(&obj_data->length, value);
}*/

/*
void line_segment_setd(PrimitiveBase *obj, char *key, float value)
{
	line_segment_data *obj_data = (line_segment_data*) obj->data;
	
	if( strequal(key, "length") )
		obj_data ->length = value;
}*/

