#include <math.h>
#include <stdio.h>
#include <time.h>
#include "../Primitives/PrimitiveBase.h"
#include "../common/Vector3.h"
#include "../common/misc.h"
#include "../common/debug.h"
//#include "../render/vector.c"
#include "Plane.h"

extern SlimScene* main_scene;

bool Plane::rayIntersect(const Ray &r, HitPoint &h)
{
	float normDproj;
	float normDobj;
	float distance;
	vector3 obj_vector;

	normDproj = this->norm.dot( r.getDir() );

	if(normDproj == 0) //parallel check
		return false;

	obj_vector = this->pos - r.getOrigin();

	normDobj = this->norm.dot( obj_vector);
	
	
	
//pthread_mutex_lock (&mutexor);
	distance = normDobj / normDproj;
//pthread_mutex_unlock (&mutexor);


	if(distance < 0 )
		return false;


	//intersection = projection * distance;
	//intersection = origin + intersection;

	if(distance < h.distance)
	{
		h.distance = distance;
		return true;
	}
	
	return false;
}

/*****************************************************
 Calculates the normal vector at a point, on an Primitive
 *****************************************************/
vector3 Plane::normalAtPoint(const vector3 &p)
{
	vector3 n;
	n.c[0] = this->norm.c[0];
	n.c[1] = this->norm.c[1];
	n.c[2] = this->norm.c[2];
	return n;
}


//extern clock_t current_time;

vector3 normal_wavey_plane(vector3& q, PrimitiveBase* PrimitiveHit, vector3 n)
{
	float dist = 0.0;
vector3 bend;

	n.c[0] = PrimitiveHit->norm.c[0];
	n.c[1] = PrimitiveHit->norm.c[1];
	n.c[2] = PrimitiveHit->norm.c[2];
	
	//setup the bumpy surface
	dist = q.distance(PrimitiveHit->pos);
	bend = vector3(q - PrimitiveHit->pos); 
	bend.normalize();
	
	//bend = bend * sin(dist+current_time/TIME_SCALE);
	bend = bend * 0.12;
	n = n + bend;

	return n;
}
