#ifndef __PRIMITIVE_H
#define __PRIMITIVE_H

#include "../common/Common.h"
#include "../common/Vector3.h"
#include "../common/Color.h"
#include "../common/HitPoint.h"
#include "../common/Ray.h"
#include <vector>

#define MAX_OBJ_NAME 16

class PrimitiveBase
{
public:
	char name[MAX_OBJ_NAME];
	char no_shadow;
	int obj_type;
	int id;
	vector3 pos;
	vector3 rot;
	Color amb;
	Color spec;
	Color diff;
	Color emit;
	vector3 up;
	vector3 norm;
	float spec_alpha;
	float radius;
	float trans;
	float glossy;  //perfect reflection is 1.0, blurry is 0.5, diffuse scatter is 0.0
	float refract_index;
	float reflect;
	float dist;
	char collided;
	
	vector3 bbMin;
	vector3 bbMax;
	
	float rotation[3][3];
	
	//state st;
	
	//model *polygon;
	
	void *data;
	
	//void* shader;
	//vector3 (*normal) (vector3& p, void* obj, vector3& v);
	//float (*intersect) (vector3& startP, vector3& projV, void* obj, vector3& pntIntersect);
	void* (*shader) (void *id, Color *new_Color);
	//void* (*position) (void *id, Color *new_Color);
	
	vector3 (*inverse_map) (vector3& p, void* obj, vector3& v);
	
	PrimitiveBase()
	{
		this->bbMin = vector3(maxFloat,maxFloat,maxFloat);
		this->bbMax = vector3(minFloat,minFloat,minFloat);
	}
	
	PrimitiveBase(int objN)
	{
		this->id = objN;
		this->obj_type = objN;
		this->bbMin = vector3(maxFloat,maxFloat,maxFloat);
		this->bbMax = vector3(minFloat,minFloat,minFloat);
	}
	
	PrimitiveBase* setMisc(float t, float rl, float ra, float rad, float sa);
	
	virtual vector3 normalAtPoint(const vector3 &p)
	{
		return vector3();
	}
	
	virtual bool rayIntersect(const Ray &r, HitPoint &h)
	//virtual slimFloat rayIntersect(const vector3 &origin, const vector3 &dir, vector3 &intersectPoint)
	{
		return false;
	}
	
	virtual vector3 center()
	{
		return this->pos;
	}
	
	virtual void setup() { }
};

typedef std::vector<PrimitiveBase> PrimitiveList;
//typedef PrimitiveList::iterator PrimitiveListIterator;
typedef std::vector<PrimitiveBase*> PrimitivePtrList;

#endif
