#include <math.h>
#include <stdio.h>
#include <time.h>
#include "../Primitives/PrimitiveBase.h"
#include "../common/scene.h"
#include "../common/Vector3.h"
#include "../common/misc.h"
#include "../common/debug.h"
//#include "../render/vector.c"
#include "../parse/parser.h"
#include "Plane.h"
#include "../common/string_extra.h"
#include "Rectangle.h"

extern SlimScene* main_scene;

slimFloat Rectangle::rayIntersect(const vector3 &origin, const vector3 &projection, vector3 &old_intersection)
//float intersect_rectangle(vector3& origin, vector3& projection, PrimitiveBase* obj,
//	vector3& old_intersection)
{
	float normDproj;
	float normDobj;
	float distance;
	vector3 obj_vector;
	vector3 intersection;
	
	vector3 trans_intersect;
	vector3 boundary_vector;
	float boundary_length;
	float boundary_proj;

	normDproj = this->norm.dot( projection);

	if(normDproj == 0) //parallel check
		return 0;

//	if(normDproj > 0) //cull backfaces
//		return 0;
	obj_vector = this->pos - origin;

	normDobj = this->norm.dot( obj_vector);
	
	
	
//pthread_mutex_lock (&mutexor);
	distance = normDobj / normDproj;
//pthread_mutex_unlock (&mutexor);


	if(distance < 0 )
		return 0;

	//check if point is within bounds
	intersection = projection * distance;
	intersection = origin + intersection;

	trans_intersect = vector3(this->pos);
	trans_intersect = -trans_intersect;
	trans_intersect = trans_intersect + intersection;
	
	boundary_length = this->height;
	boundary_vector = this->up * boundary_length;

	//boundary_proj = intersection.dot( boundary_vector);
	boundary_proj = trans_intersect.dot( boundary_vector);
	boundary_proj = boundary_proj / boundary_length;

//	main_scene->models[3]->pos = vector3(boundary_vector);
	
	if(boundary_proj > boundary_length)
	{
		return 0;
		this->diff.r = 0;
		this->diff.g = 255;
		this->diff.b = 0;
		return distance;
	}
	
	if(boundary_proj < -boundary_length)
	{
		return 0;
		this->diff.r = 0;
		this->diff.g = 0;
		this->diff.b = 255;
		return distance;
	}


	boundary_length = this->width;

	boundary_vector = this->rot * boundary_length;
	boundary_proj = trans_intersect.dot( boundary_vector);
	boundary_proj = boundary_proj / boundary_length;

	if(boundary_proj > boundary_length)
	{
		return 0;
		this->diff.r = 255;
		this->diff.g = 0;
		this->diff.b = 0;
		return distance;
	}

	if(boundary_proj < -boundary_length)
	{
		return 0;
		this->diff.r = 255;
		this->diff.g = 255;
		this->diff.b = 0;
		return distance;
	}
		
//	obj->diff.r = 255;
//	obj->diff.g = 255;
//	obj->diff.b = 255;


	return distance;
}

/*****************************************************
 Calculates the normal vector at a point, on an Primitive
 *****************************************************/
//vector3 normal_rectangle(vector3& q, PrimitiveBase* PrimitiveHit, vector3 n)
vector3 Rectangle::normalAtPoint(const vector3 &q)
{
	vector3 n;
	n.c[0] = this->norm.c[0];
	n.c[1] = this->norm.c[1];
	n.c[2] = this->norm.c[2];
	return n;
}

/*
model *rectangle_polygon(PrimitiveBase *obj)
{
	model *m;
	
	m = (model*)malloc(sizeof(model));
	//FIXME: this alloc is broke
	//m->points = (vector3)malloc(4 * sizeof(vector3));
	m->triangles = (triangle*)malloc(2 * sizeof(triangle));
	
	m->points[0] = obj->up + obj->rot;
	m->points[2] = m->points[0] * -obj->radius;
	m->points[0] = m->points[0] * obj->radius;

	m->points[1] = vector3(obj->rot);
	m->points[1] = -m->points[1];
	m->points[1] = obj->up + m->points[1];
	m->points[3] = m->points[1] * -obj->radius;
	m->points[1] = m->points[1] * obj->radius;
	
	m->triangles[0].vertices[0] = &m->points[0];
	m->triangles[0].vertices[1] = &m->points[1];
	m->triangles[0].vertices[2] = &m->points[2];

	m->triangles[1].vertices[0] = &m->points[0];
	m->triangles[1].vertices[1] = &m->points[2];
	m->triangles[1].vertices[2] = &m->points[3];

	m->num_triangles = 2;
	m->num_points = 4;

	return m;
}
*/

/*
PrimitiveBase *rectangle_create(int obj_number)
{
	PrimitiveBase* obj;
	obj = (PrimitiveBase*) (malloc (sizeof(PrimitiveBase)));
	
	obj->obj_type = RECTANGLE;
	obj->id = obj_number;
	//obj->data = malloc( sizeof(rectangle_data) );
	//obj->intersect =  (float (*)(vector3&, vector3&, void*, vector3&))&intersect_rectangle;
	//obj->normal =  (vector3 (*)(vector3&, void*, vector3&))&normal_rectangle;
	
	return obj;
}

void rectangle_make_normal(vector3& norm, vector3& first, vector3& second, vector3& third)
{
	vector3 v1;
	vector3 v2;
	
	v1 = first - second;
	v2 = third - second;
	
	norm = v1.cross(v2);
	norm.normalize();
}*/

void Rectangle::setup()
{	
	this->rot = this->norm.cross(this->up);
	this->rot.normalize();
	this->up = this->rot.cross(this->norm);
	this->up.normalize();
	
	//obj->polygon = rectangle_polygon(obj);
}

/*
void rectangle_set(PrimitiveBase *obj, char *key, char *value)
{
	//rectangle_data *rec_data = (rectangle_data*) obj->data;
	
	if( strequal(key, "height") );
	//assign_float(&rec_data->height, value);
	
	else if( strequal(key, "width") );
	//assign_float(&rec_data->width, value);
}

void rectangle_setd(PrimitiveBase *obj, char *key, float value)
{
	//rectangle_data *rec_data = (rectangle_data*) obj->data;
	
	if( strequal(key, "height") );
	//rec_data->height = value;
	
	else if( strequal(key, "width") );
	//rec_data->width = value;
}


void rectangle_from_points(PrimitiveBase *obj, vector3 vertices[])
{
	//position
	obj->pos = vertices[0] + vertices[1];
	obj->pos = obj->pos + vertices[2];
	obj->pos = obj->pos + vertices[3];
	obj->pos = obj->pos * 0.25;
	

	//normal
	rectangle_make_normal(obj->norm, vertices[0], vertices[1], vertices[2]);
	
	//up vector, width, and height
	obj->up = vertices[1] - vertices[0];
	obj->up = obj->up * 0.5;
	rectangle_setd(obj,  "height", obj->up.length());
	obj->rot = vertices[2] - vertices[1];
	obj->rot = obj->rot * 0.5;
	rectangle_setd(obj,  "width", obj->rot.length());
	
	//rectangle_setup(obj);
}

void rectangle_closest_point(PrimitiveBase *obj,vector3 *v)
{
}
*/
