#include <math.h>
#include <stdio.h>
#include "../Primitives/PrimitiveBase.h"
#include "../common/Vector3.h"
#include "../common/debug.h"
//#include "../render/vector.c"
#include "Sphere.h"
#include "../shader/shaders.h"

//extern SlimScene* main_scene;

//extern inline float vector3 a.dot( vector3 b);

//slimFloat Sphere::rayIntersect(vector3& startP, vector3 projV, 
//float intersect_PrimitiveBase(vector3& startP, vector3 projV, PrimitiveBase* sphere,
//		vector3& pntIntersect)
bool Sphere::rayIntersect(const Ray &r, HitPoint &h)
{
	slimFloat distA;	
	slimFloat distB;
	slimFloat finalDist;
	vector3 diffVector;
	slimFloat dpDDiff;		
	slimFloat dpDD;
	slimFloat dpDiffDiff;
	slimFloat determinant; 
	slimFloat ep = 0.1;
	//vector3 normal;
	
	//printd(DEBUG,"{intersect_sphere\n");

	diffVector = r.getOrigin() - this->pos;

	dpDDiff = r.getDir().dot(diffVector);
	dpDD = r.getDir().dot(r.getDir());
	dpDiffDiff = diffVector.dot(diffVector);

//	pntIntersect.c[0] = startP.c[0];
//	pntIntersect.c[1] = startP.c[1];
//	pntIntersect.c[2] = startP.c[2];
	
	determinant = (dpDDiff * dpDDiff - dpDD *
			(dpDiffDiff - this->radius * this->radius));

	if(determinant < 0)
	{
		return false;
	}

	distA = (-dpDDiff + sqrt(determinant)) / dpDD;
	distB = (-dpDDiff - sqrt(determinant)) / dpDD;

	if(distA < ep && distB < ep)	// Can't use negative xIntersects
	{
		return false;
	}
	else if(distA > ep && distB > ep)
	{
		if(distA < distB)
		{
			finalDist = distA;
		}
		else
		{
			finalDist = distB;
		}
	}
	else if(distA > ep)  // If only one is positive, figure out which one
	{
		finalDist = distA;
	}
	else
	{
		finalDist = distB;
	}

	//pntIntersect.c[0] = startP.c[0] + projV.c[0]*finalDist;
	//pntIntersect.c[1] = startP.c[1] + projV.c[1]*finalDist;
	//pntIntersect.c[2] = startP.c[2] + projV.c[2]*finalDist;

	
	//normal_sphere(pntIntersect, sphere, &normal);

	//hack to make refraction work
//	if( normal.dot( projV) > 1)
//		return 0;
	
	
	//printd(DEBUG,"}interset_sphere\n");
	if(finalDist < h.distance)
	{
		h.distance = finalDist;
		return true;
	}
	
	return false;
}


/*
Point* intersectSphere(Point* startP, vector3 projV, PrimitiveBase* sphere,
		Point* intersectP)
{
vector3 distanceV; 
	float tca;		
	float dist2;
	float thc2;
	float intersectDis;
	float rsq;

	rsq = sqrt(sphere->radius);
	// get the distance from the sphere to the start
	distanceV.c[0] = sphere->posX - startP.c[0];
	distanceV.c[1] = sphere->posY - startP.c[1];
	distanceV.c[2] = sphere->posZ - startP.c[2];

	// dot the sphere->start distance with the projection vector
	tca = dotProduct(projV,&distanceV);

	// if this is negative, the sphere lies behind the camera
	if( tca < 0 )
		return startP;

	// now find the distance from entry to the sphere to the hemisphere
	dist2 = dotProduct(&distanceV, &distanceV);
	//this is the sqrt of the radius - the distance from start to hemisphere
	thc2 = rsq - dist2;

	//if thc2 is negative, no intersection
	if( thc2 < 0 )
		return startP;

	intersectDis = tca - sqrt(thc2);

	intersectP.c[0] = startP.c[0] + projV.c[0]*intersectDis;
	intersectP.c[1] = startP.c[1] + projV.c[1]*intersectDis;
	intersectP.c[2] = startP.c[2] + projV.c[2]*intersectDis;
	
	return intersectP;
}
*/

/* fix: this needs to be killed */
/*
inline float vector3 a.dot( vector3 b)
{
	    return a.c[0]*b.c[0] + a.c[1]*b.c[1] + a.c[2]*b.c[2];
}
*/

/*****************************************************
 Calculates the normal vector at a point, on an Primitive
 *****************************************************/
//vector3 Sphere::normalAtPoint(vector3& q, PrimitiveBase* PrimitiveHit, vector3 n)
vector3 Sphere::normalAtPoint(const vector3 &q)
{
	vector3 n;
	n.c[0] = q.c[0] - this->pos.c[0];
	n.c[1] = q.c[1] - this->pos.c[1];
	n.c[2] = q.c[2] - this->pos.c[2];
	return n;
}


/*
vector3 inverse_map_sphere(vector3& q, PrimitiveBase* PrimitiveHit, vector3 uv)
{
	float latitude;
	float longitude;
	//float u, v;
	float cross_dot_norm;
	vector3 normal;
	vector3 crossp;
	
	normal_sphere(q, PrimitiveHit, normal);
	
	latitude = normal.angle(PrimitiveHit->up);
	latitude = latitude / M_PI;
	
	longitude = normal.angle(PrimitiveHit->norm);
	longitude = longitude / sin(latitude);
	longitude = longitude / (2 * M_PI);

	crossp = PrimitiveHit->norm.cross(PrimitiveHit->up);
	cross_dot_norm = crossp.dot( normal);
	
	if(cross_dot_norm <= 0)
		longitude = 1 - longitude;

	uv.c[0] = longitude;
	uv.c[1] = latitude;
	return uv;
}
 */

/*
uses ideas from:
http://www.whisqu.com/per/docs/math31.htm
http://ozark.hendrix.edu/~burch/cs/490/sched/feb8/
http://local.wasp.uwa.edu.au/~pbourke/texture_colour/spheremap/index.html
http://in4k.untergrund.net/html_articles/hugi_27_-_coding_corner_polaris_sphere_tessellation_101.htm
*/
/*
model *sphere_polygon(PrimitiveBase *obj, int n)
{
	int i, j;
	int point_offset, tri_offset;
	int top_point, bottom_point;
	int next_top_point, next_bottom_point;
	float x, y, z;
	float dis;
	vector3 *v;
	model *m;
	//PrimitiveBase *o;
	//vector3 a;
	int num_polys = 0;
	
	m = (model*)malloc(sizeof(model));

	printd(INSANE, "tessellating sphere of %i\n", n);
	printd(INSANE, "\n");
	//there are n points in each band
	//there are n-1 circles of points
	//there is a point at the top, and one at the bottom
	m->points = (vector3)malloc((n*(n-1) + 2) * sizeof(vector));
	
	//there are n triangles in the top cap
	//there are n triangles in the bottom cap
	//there are 2n triangles in each of the n-2 bands
	m->triangles = (triangle*)malloc( (n + n + 2*n*(n-2)) * sizeof(triangle));

	m->num_triangles = (n + n + 2*n*(n-2));
	m->num_points = (n*(n-1) + 2);

	v = m->points;
	
	//create the top point
	v.c[0] = 0;
	v.c[1] = obj->radius;
	v.c[2] = 0;
	print_vector(INSANE,"p ", v);


	//o = sphere_create();
	//o->pos = vector3(v);
	//o->id = main_scene->num_Primitives;
	//o->radius = 0.5;
	//main_scene->models[main_scene->num_Primitives] = o;
	//main_scene->num_Primitives++;
	
	v++;

	//create the points for each band
	//the angle between bands is pi/n
	//the y values from the top are sin(pi/2 - pi/i)
	for(j=1; j<n; j++)
	{
		y = sin(M_PI/2 - j*(M_PI/n));
		y = y * obj->radius;   //from unit sphere to desired radius
		
		dis = cos(M_PI/2 - j*(M_PI/n));  //distance of x,z vector
		
		//now create the x and z values
		for(i=0; i<n; i++)
		{
			x = sin(M_PI/2 - i*(2*M_PI/n)); //divide circle (2pi) into n chunks
			z = cos(M_PI/2 - i*(2*M_PI/n));
			x = x * obj->radius * dis;  //scale by distance and radius
			z = z * obj->radius * dis;  //scale by distance and radius
			
			v.c[0] = x;
			v.c[1] = y;
			v.c[2] = z;
			
			print_vector(INSANE,"p ", v);

			//o = sphere_create();
			//o->pos = vector3(v);
			//o->id = main_scene->num_Primitives;
			//o->radius = 0.5;
			//main_scene->models[main_scene->num_Primitives] = o;
			//main_scene->num_Primitives++;
			v++;
		}
	}
	
	//create the bottom point
	v.c[0] = 0;
	v.c[1] = -obj->radius;
	v.c[2] = 0;
	print_vector(INSANE,"p ", v);

	//o = sphere_create();
	//o->pos = vector3(v);
	//o->id = main_scene->num_Primitives;
	//o->radius = 0.5;
	//main_scene->models[main_scene->num_Primitives] = o;
	//main_scene->num_Primitives++;
	
	v++;

	printd(12, "\n");
	//top cap triangles
	point_offset = 1;  //skip top point
	tri_offset = 0;
	for(i=0; i<n; i++)
	{
		m->triangles[tri_offset].vertices[0] = &m->points[0];
		m->triangles[tri_offset].vertices[1] = &m->points[point_offset+i];
		m->triangles[tri_offset].vertices[2] = &m->points[point_offset+i+1];
		
		if(i == n-1)
			m->triangles[tri_offset].vertices[2] = &m->points[point_offset];
		num_polys++;
		print_vector(INSANE,"t1 ",m->triangles[tri_offset].vertices[0]);
		print_vector(INSANE,"t2 ",m->triangles[tri_offset].vertices[1]);
		print_vector(INSANE,"t3 ",m->triangles[tri_offset].vertices[2]);
		tri_offset++;
	}
	
	printd(INSANE, "\n");
	//band triangles
	for(i=0; i<(n-2); i++)  //create n-2 bands
	{
		top_point = 1 + i*n;  //skip top point, go to next section
		bottom_point = top_point + n;

		for(j=0; j<n; j++)
		{
			next_top_point = top_point + j + 1;
			next_bottom_point = bottom_point + j + 1;
			
			if(next_top_point - top_point == n)
				next_top_point = top_point;

			if(next_bottom_point - bottom_point == n)
				next_bottom_point = bottom_point;

			printd(INSANE, "triangle\n");
			//top triangle in the band
			m->triangles[tri_offset].vertices[0] = &m->points[top_point+j];
			m->triangles[tri_offset].vertices[1] = &m->points[bottom_point+j];
			m->triangles[tri_offset].vertices[2] = &m->points[next_top_point];
			num_polys++;
			
			printd(INSANE, "p[%i] ", top_point+j);
			print_vector(INSANE,"",m->triangles[tri_offset].vertices[0]);
			printd(INSANE, "p[%i] ", bottom_point+j);
			print_vector(INSANE,"",m->triangles[tri_offset].vertices[1]);
			printd(INSANE, "p[%i] ", next_top_point+j);
			print_vector(INSANE,"",m->triangles[tri_offset].vertices[2]);
			tri_offset++;

			printd(INSANE, "triangle\n");			
			//bottom triangle in the band
			m->triangles[tri_offset].vertices[0] = &m->points[bottom_point+j];
			m->triangles[tri_offset].vertices[1] = &m->points[next_bottom_point];
			m->triangles[tri_offset].vertices[2] = &m->points[next_top_point];
			num_polys++;
			
			printd(INSANE, "p[%i] ", bottom_point+j);
			print_vector(INSANE,"t1 ",m->triangles[tri_offset].vertices[0]);
			printd(INSANE, "p[%i] ", next_bottom_point+j);
			print_vector(INSANE,"t2 ",m->triangles[tri_offset].vertices[1]);
			printd(INSANE, "p[%i] ", next_top_point+j);
			print_vector(INSANE,"t3 ",m->triangles[tri_offset].vertices[2]);
			tri_offset++;
		}
			printd(INSANE, "\n");
	}

	//bottom cap triangles
	point_offset = (n*(n-1) + 2) - 1 - n;  //skip to last band's points
	for(i=0; i<n; i++)
	{
		m->triangles[tri_offset].vertices[0] = &m->points[(n*(n-1) + 2)-1];
		m->triangles[tri_offset].vertices[1] = &m->points[point_offset+i];
		m->triangles[tri_offset].vertices[2] = &m->points[point_offset+i+1];
		num_polys++;
		
		if(i == n-1)
			m->triangles[tri_offset].vertices[2] = &m->points[point_offset];
		print_vector(INSANE,"t1 ",m->triangles[tri_offset].vertices[0]);
		print_vector(INSANE,"t2 ",m->triangles[tri_offset].vertices[1]);
		print_vector(INSANE,"t3 ",m->triangles[tri_offset].vertices[2]);
		tri_offset++;
	}
	
	/*
	for(i=0; i<(n + n + 2*n*(n-2)); i++)
//	for(i=0; i<3; i++)
	{
		a = m->triangles[i].vertices[0] + m->triangles[i].vertices[1];
		a = a + m->triangles[i].vertices[2];
		a = a * 0.3333333;

		o = sphere_create();
		o->pos = vector3(a);
		o->id = main_scene->num_Primitives;
		o->radius = 0.5;
		make_color(&o->diff,0, 300, 0);
		main_scene->models[main_scene->num_Primitives] = o;
		main_scene->num_Primitives++;
	}*/
	/*
	m->tris[0] = 0;
	m->tris[1] = 1;
	m->tris[2] = 2;

	m->tris[3] = 0;
	m->tris[4] = 2;
	m->tris[5] = 3;
*/
	//return m;
//}

/*
PrimitiveBase *sphere_create()
{
	PrimitiveBase *o;
 */
	/*
	o = (PrimitiveBase*)malloc(sizeof(Primitive));
	o->radius = 1;
	o->pos.c[0] = 0; o->pos.c[1] = 0; o->pos.c[2] = 0;
	o->up.c[0] = 0; o->up.c[1] = 1; o->up.c[2] = 0;
	o->norm.c[0] = 1; o->norm.c[1] = 0; o->norm.c[0] = 0;
	
	o->trans = 0;
	o->reflect = 0;
	o->refract = 0;
	
	o->amb.r = 200; o->amb.g = 200; o->amb.b = 200;
	*/
/*
	o = new PrimitiveBase(SPHERE, 0);
	o->pos = vector3(0, 0, 0);
	make_color(&o->amb, 100, 100, 100);
	make_color(&o->spec, 0, 0, 0);
	make_color(&o->diff, 200, 200, 200);
	o->norm = vector3(1, 0, 0);
	o->up = vector3(0, 1, 0);
	o->setMisc(0, 0, 0, 1, 0);
	o->collided = 0;

	o->shader = (void* (*)(void*, color*)) general_shader;
	o->intersect =  (float (*)(vector3&, vector3&, void*, vector3&)) &intersect_sphere;
	o->normal =  (vector3 (*)(vector3&, void*, vector3&)) &normal_sphere;
	o->inverse_map =  (vector3 (*)(vector3&, void*, vector3&)) &inverse_map_sphere;
	o->no_shadow = 0;
	
	return o;
}
*/

void Sphere::setup()
{
	this->bbMin = pos - radius;
	this->bbMax = pos + radius;
}

