#include <math.h>
#include <stdio.h>
#include <time.h>
#include "../Primitives/PrimitiveBase.h"
#include "../common/scene.h"
#include "../common/Vector3.h"
#include "../common/misc.h"
#include "../common/debug.h"
//#include "../render/vector.c"
#include "../parse/parser.h"
//#include "Plane.h"
#include "Triangle.h"
#include "../common/string_extra.h"


extern SlimScene* main_scene;

// algorithm from: www.cs.cornell.edu/Courses/ cs465/2003fa/homeworks/raytri.pdf 
//float intersect_triangle(vector3& origin, vector3& projection, PrimitiveBase* obj, vector3& old_intersection)
bool Triangle::rayIntersect(const Ray &r, HitPoint &h)
{ return fastIntersect(r, h); }

bool Triangle::fastIntersect(const Ray &r, HitPoint &h)
{
	float normDproj;
	float normDobj;
	float distance;
	vector3 obj_vector;
	//triangle_data *obj_data = (triangle_data*)this->data;

	normDproj = this->norm.dot(r.getDir());

	if(normDproj == 0) //parallel check
		return 0;

	obj_vector = vertex[0] - r.getOrigin();

	normDobj = this->norm.dot(obj_vector);
	
	distance = normDobj / normDproj;

	if(distance < 0 )
		return false;
	
//	return distance;
	
	//hit the plane- time to check if inside triangle
	//do so by checking if cross product of vectors points with normal
	
	vector3 v1, v2, v3, hit;
	hit = r.getDir() * distance;
	hit = hit + r.getOrigin();
	
	v1 = vertex[1] - vertex[0];
	v2 = hit - vertex[0];
	v3 = v1.cross(v2);
	if( v3.dot(this->norm) < 0)
	{
		return false;
		//this->amb.r = 255;
		//this->amb.g = 0;
		//this->amb.b = 0;
		//h.distance = distance;
		//return true;
	}

	v1 = vertex[2] - vertex[1];
	v2 = hit - vertex[1];
	v3 = v1.cross(v2);
	if( v3.dot(this->norm) < 0)
	{
		return false;
		//this->amb.r = 0;
		//this->amb.g = 255;
		//this->amb.b = 0;
		//h.distance = distance;
		//return true;
	}

	v1 = vertex[0] - vertex[2];
	v2 = hit - vertex[2];
	v3 = v1.cross(v2);
	if( v3.dot(this->norm) < 0)
	{
		return false;
		//this->amb.r = 0;
		//this->amb.g = 0;
		//this->amb.b = 255;
		//h.distance = distance;
		//return true;
	}

	if(distance > EPSILON && distance < h.distance)
	{
		h.distance = distance;
		return true;
	}
	
	return false;
}

vector3 Triangle::normalAtPoint(const vector3 &q)
//vector3 normal_triangle(vector3& q, PrimitiveBase* PrimitiveHit, vector3& n)
{
	vector3 n;
	n.c[0] = this->norm.c[0];
	n.c[1] = this->norm.c[1];
	n.c[2] = this->norm.c[2];
	return n;
}


/*
PrimitiveBase *triangle_create(int obj_number)
{
	PrimitiveBase* obj;
	obj = (PrimitiveBase*) (malloc (sizeof(Primitive)));
	
	obj->obj_type = TRIANGLE;
	obj->id = obj_number;
	obj->data = malloc( sizeof(triangle_data) );
	//obj->intersect =  (float (*)(vector3&, vector3&, void*, vector3&))&intersect_triangle;
	//obj->normal =  (vector3 (*)(vector3&, void*, vector3&))&normal_triangle;
	
	return obj;
}*/

void Triangle::makeNormal()
{
	vector3 v1;
	vector3 v2;
	
	v1 = vertex[1] - vertex[0];
	v2 = vertex[2] - vertex[1];
	
	this->norm = v1.cross(v2);
	this->norm.normalize();
}

void Triangle::fromPoints(vector3 *vertices)
{
	this->fromPoints(vertices[0], vertices[1], vertices[2]);
}

void Triangle::fromPoints(vector3& v1, vector3& v2, vector3& v3)
{
//	triangle_data *obj_data = (triangle_data*)obj->data;
	this->vertex[0] = vector3(v1);
	this->vertex[1] = vector3(v2);
	this->vertex[2] = vector3(v3);
	
	this->setup();
}

#include <limits>
void Triangle::setup()
{
	//triangle_data *obj_data = (triangle_data*)obj->data;
	
	//normal
	this->makeNormal();
	
	//update bounding box
	for(int i=0; i<3; i++)
	{
		for(int j=0; j<3; j++)
		{
			if(this->vertex[i].c[j] > bbMax[j])
				bbMax[j] = this->vertex[i].c[j];
			if(this->vertex[i].c[j] < bbMin[j])
				bbMin[j] = this->vertex[i].c[j];
		}
	}
	
	//obj->polygon = triangle_polygon(obj);
}

/*
void triangle_set(PrimitiveBase *obj, char *key, char *value)
{
	triangle_data *rec_data = (triangle_data*) obj->data;
	
	if( strequal(key, "height") )
		assign_float(&rec_data->height, value);
	
	else if( strequal(key, "width") )
		assign_float(&rec_data->width, value);
}*/

/*
void triangle_set_vector(PrimitiveBase *obj, char *key,vector3& v)
{
	triangle_data *obj_data = (triangle_data*) obj->data;
	
	if( strequal(key, "vertex0") )
		obj_data->vertex[0] = vector3(v);
	else if( strequal(key, "vertex1") )
		obj_data->vertex[1] = vector3(v);
	else if( strequal(key, "vertex2") )
		obj_data->vertex[2] = vector3(v);
}*/

void triangle_closest_point(PrimitiveBase *obj,vector3 *v)
{
}

vector3 Triangle::center()
{
	return (vertex[0] + vertex[1] + vertex[2]) * 0.33333;
}
