#ifndef __CAMERA_H
#define __CAMERA_H

#include "Vector3.h"
#include "Matrix.h"
#include "../common/Ray.h"

class Camera
{
public:
	float horzFOV;
	float vertFOV;
	float aspectRatio;
	vector3 pos;
	vector3 lookAtPoint;
	vector3 up;
	vector3 look;
	vector3 horz;
	vector3 vert;
	vector3 topLeftCorner;
	
	void setupLookPoint();
	void setupCamera();
	//void getImageCoords(vector3 &imageCoord, const vector3 &proj);
	void handleInput(float xMovement, float yMovement);
	void getImageCoords(vector3 &imageCoord, const vector3 &proj);
	GraphicMatrix getFrustum();
	GraphicMatrix getProjection();
	GraphicMatrix getProjectionFOV();
	GraphicMatrix getLookAt();
	GraphicMatrix getPerspectiveScaling();
	
	Ray getEyeRay(slimFloat x, slimFloat y)
	{
		vector3 dir;
		
		dir = topLeftCorner - spreadAcrossHorz*x - spreadDownVert*y;
		//dir.normalize();
		
		return Ray(this->pos, dir);
	}
	
private:
	float spreadAcross;
	float spreadDown;
	vector3 spreadAcrossHorz;
	vector3 spreadDownVert;
	float imagePlaneDistance;
};

#endif
