#include "Color.h"

Color ColorBand(slimFloat range[2], slimFloat mid[3], slimFloat to_check)
{
	//false Color shader for density
	static const Color b = Color(0,0,255);
	static const Color r = Color(255,0,0);
	static const Color g = Color(0,255,0);
	
	slimFloat bbottom = range[0];
	slimFloat bmid = mid[0];
	slimFloat btop = mid[1];
	slimFloat gbottom = mid[0];
	slimFloat gmid = mid[1];
	slimFloat gtop = mid[2];
	slimFloat rbottom = mid[1];
	slimFloat rmid = mid[2];
	slimFloat rtop = range[1];

	slimFloat bs = (to_check > bbottom && to_check < bmid) ? to_check / bmid : 0.0f;
	if (to_check > bmid && to_check < btop) { bs = (btop - to_check) / (btop - bmid); };
	if (to_check == bmid) bs = 1.0;
	slimFloat gs = (to_check > gbottom && to_check < gmid) ? to_check / gmid : 0.0f;
	if (to_check > gmid && to_check < gtop) { gs = (gtop - to_check) / (gtop - gmid); };
	if (to_check == gmid) gs = 1.0;
	slimFloat rs = (to_check > rbottom && to_check < rmid) ? to_check / rmid : 0.0f;
	if (to_check > rmid && to_check < rtop) { rs = (rtop - to_check) / (rtop - rmid); };
	if (to_check == rmid) rs = 1.0;

	Color outColor;
	outColor.clear();
	outColor = b*bs + g*gs + r*rs;

	return outColor;
}

Color operator+(const Color &c1, const Color &c2)
{
	Color t;
	t.r = c1.r + c2.r;
	t.g = c1.g + c2.g;
	t.b = c1.b + c2.b;
	return t;
}

Color operator-(const Color &c1, const Color &c2)
{
	Color t;
	t.r = c1.r - c2.r;
	t.g = c1.g - c2.g;
	t.b = c1.b - c2.b;
	return t;
}

Color operator*(const Color &c1, const Color &c2)
{
	Color t;
	t.r = c1.r * c2.r;
	t.g = c1.g * c2.g;
	t.b = c1.b * c2.b;
	return t;
}	

Color operator*(const float f, const Color &c1)
{
	Color t;
	t.r = c1.r * f;
	t.g = c1.g * f;
	t.b = c1.b * f;
	return t;
}

Color operator*(const Color &c1, const float f)
{
	Color t;
	t.r = c1.r * f;
	t.g = c1.g * f;
	t.b = c1.b * f;
	return t;
}

Color operator/(const Color &c1, const float f)
{
	Color t;
	t.r = c1.r / f;
	t.g = c1.g / f;
	t.b = c1.b / f;
	return t;
}

