#ifndef __COLOR_H
#define __COLOR_H
	
#include "Common.h"
#define COLOR_SIZE 3

class Color
{
public:
	float r, g, b;
	
	Color()
	{ this->clear(); }
	
	Color(slimFloat red, slimFloat green, slimFloat blue)
	{ this->r = red; this->g = green; this->b = blue; }
	
	Color(int n)
	{
		this->r = ((n+1)*267) % 255;
		this->g = ((n+1)*48000) % 255;
		this->b = ((n+1)*963) % 255;
	}
	
	float componentSum()
	{
		return this->r + this->g + this->b;
	}
	
	void operator+=(const Color &c)
	{
		this->r += c.r;
		this->g += c.g;
		this->b += c.b;
	}
	
	void operator*=(float f)
	{
		this->r *= f;
		this->g *= f;
		this->b *= f;
	}
	
	void operator/=(float f)
	{
		this->r /= f;
		this->g /= f;
		this->b /= f;
	}
	
	void clear()
	{
		this->r = 0.0;
		this->g = 0.0;
		this->b = 0.0;
	}
	
	void toRGB()
	{
		if (this->r < 0.0)
			this->r = 0.0;
		if (this->g < 0.0)
			this->g = 0.0;
		if (this->b < 0.0)
			this->b = 0.0;
		
		if (this->r > 255)
			this->r = 255;
		if (this->g > 255)
			this->g = 255;
		if (this->b > 255)
			this->b = 255;
	}
};

Color operator+(const Color &c1, const Color &c2);
Color operator-(const Color &c1, const Color &c2);
Color operator*(const Color &c1, const Color &c2);
Color operator*(const float f, const Color &c1);
Color operator*(const Color &c1, const float f);
Color operator/(const Color &c1, const float f);

Color ColorBand(slimFloat range[2], slimFloat mid[3], slimFloat to_check);

#endif
