#include <math.h>
#include <stdlib.h>
#include "../Primitives/PrimitiveBase.h"
#include "Vector3.h"
#include "../common/scene.h"
#include "../common/debug.h"

void create_rotation_matrix(float rotation[3][3], float x, float y, float z)
{
	rotation[0][0] = cos(y)*cos(z);
	rotation[0][1] = -sin(z);
	rotation[0][2] = sin(y);
	
	rotation[1][0] = sin(z);
	rotation[1][1] = cos(x)*cos(z);
	rotation[1][2] = -sin(x);

	rotation[2][0] = -sin(y);
	rotation[2][1] = sin(x);
	rotation[2][2] = cos(x)*cos(y);
}

void matrix_mul_vector(vector3& out, const float r[3][3], const vector3& v)
{
	out[0] = v[0] * r[0][0] + v[1] * r[1][0] + v[2] * r[2][0];
	out[1] = v[0] * r[0][1] + v[1] * r[1][1] + v[2] * r[2][1];
	out[2] = v[0] * r[0][2] + v[1] * r[1][2] + v[2] * r[2][2];
}
