#ifndef __RAY_H
#define __RAY_H

#include "../common/Common.h"
#include "../common/Vector3.h"

class Ray
{
public:
	Ray(const vector3 &originPoint, const vector3 &direction)
	{
		this->setOrigin(originPoint);
		this->setDir(direction);
	}
	
	inline vector3 parameter(slimFloat t) const
	{
		return origin + dir * t;
	}
	
	inline vector3 getDir() const
	{ return dir; }
	
	inline vector3 getOrigin() const
	{ return origin; }
	
	inline vector3 getReciprocal() const
	{ return reciprocal; }
	
	inline const char* getSigns() const
	{ return sign; }
	
	inline void setDir(const vector3 &d)
	{
		this->dir = d;
		this->dir.normalize();
		this->reciprocal = 1.0f / this->dir;
		this->setSign(this->reciprocal);
		this->setIndex();
	}
	
	inline void setOrigin(const vector3 &o)
	{ this->origin = o; }

	char highIndexX;
	char lowIndexX;
	char highIndexY;
	char lowIndexY;
	char highIndexZ;
	char lowIndexZ;
	
private:
	vector3 origin;
	vector3 dir;
	vector3 reciprocal;

	char sign[6];  //xyzxyz
	
	inline void setSign(const vector3 &r)
	{
		for(int i=0; i<3; i++)
		{
			sign[i] = r[i] < 0;
			sign[i+3] = 1 - sign[i];
		}
	}
	
	inline void setIndex()
	{
		this->highIndexX = this->dir[0] < 0.0 ? 0 : 1;
		this->lowIndexX = 1 - this->highIndexX;
		this->highIndexY = this->dir[1] < 0.0 ? 0 : 1;
		this->lowIndexY = 1 - this->highIndexY;
		this->highIndexZ = this->dir[2] < 0.0 ? 0 : 1;
		this->lowIndexZ = 1 - this->highIndexZ;
		
		this->highIndexX = this->highIndexX * 3 + 0;
		this->lowIndexX = this->lowIndexX * 3 + 0;
		this->highIndexY = this->highIndexY * 3 + 1;
		this->lowIndexY = this->lowIndexY * 3 + 1;
		this->highIndexZ = this->highIndexZ * 3 + 2;
		this->lowIndexZ = this->lowIndexZ * 3 + 2;
	}
};

#endif
