#ifndef __TIMER_H
#define __TIMER_H

#include "../common/Compatible.h"
#include <stdlib.h>

class Timer
{
public:
	void start()
	{ gettimeofday(&startTime, NULL); }
	
	void stop()
	{ gettimeofday(&endTime, NULL); }
	
	long int inMilliseconds()
	{
		long int seconds = endTime.tv_sec - startTime.tv_sec;
		long int microseconds = endTime.tv_usec - startTime.tv_usec;
		
		return (seconds * 1000) + (microseconds / 1000);
	}

	long int getSeconds()
	{
		long int seconds = endTime.tv_sec - startTime.tv_sec;
		return seconds;
	}
	
	long int getMicroseconds()
	{
		long int microseconds = endTime.tv_usec - startTime.tv_usec;
		return microseconds;
	}
	
private:
	timeval startTime;
	timeval endTime;
};

#endif
