#include "../common/scene.h"
#include "../common/debug.h"
#include "../Primitives/PrimitiveBase.h"
#include "../common/debug.h"
#include "../common/scene.h"
#include "../common/buffer.h"
#include "../common/Color.h"

extern SlimScene* main_scene;

/* {{{ clear_idata_buffer
 * clears the idata buffer */
INLINE void clear_idata_buffer()
{
	intersect_data *ptr;
	intersect_data *length;

	ptr = main_scene->intersect_front;
	length = main_scene->intersect_front + 
		main_scene->width*main_scene->height;

	while ( ptr < length)
	{
		ptr->obj_num = NOTHING;
		ptr++;
	}
} // }}}

/*
INLINE void set_Color(int x, int y, Color *c)
{
	int offset = array_offset(x, y);
	char *dest_Color;
	float scale = 1.0f;
	dest_Color = (char*)&main_scene->Color_front[offset * 3];

	printd(INSANE, "Writing Color %i, %i\n", x, y);
	normalize_Color(c);

	*dest_Color = (unsigned char)(c->r*scale);
	dest_Color++;
	*dest_Color = (unsigned char)(c->g*scale);
	dest_Color++;
	*dest_Color = (unsigned char)(c->b*scale);
}
*/

/* {{{ flush_Primitive_ buffer
 * clears the Primitive buffer */
/* FIXME: old Primitive buffer function- kill
void flush_Primitive_buffer()
{
	int* ptr;
	int* length;
	printd(DEBUG, "{entering flush obj buffer\n");

	ptr = main_scene->obj_buffer;
	
	length = main_scene->obj_buffer + 
		main_scene->width*main_scene->height;

	while(ptr < length)
	{
		*ptr=NOTHING;
		ptr++;
	}
	printd(DEBUG, "}exiting flush obj buffer\n");
} // }}}
*/
/* {{{ flush_Color_buffer
 * clears the Color buffer */
INLINE void flush_Color_buffer()
{
	unsigned char* ptr;
	unsigned char* length;

	ptr=main_scene->Color_front;
	length=main_scene->Color_front + 
		3*sizeof(char)*main_scene->width*main_scene->height;

	while ( ptr < length)
	{
		*ptr=0;
		ptr++;
	}
} // }}}

/* returns the offset from the beginning of an array based on height and width
 */
/*
INLINE int array_offset(int x, int y)
{
	static int ptr;  //static to avoid redeclaration each call
	printd(INSANE, "Getting offset for: %i, %i\n", x, y);
	ptr = x + y * main_scene->width;
	return ptr;
}
*/

/* {{{ get_sample */
/* FIXME: old Primitive buffer function- kill it
void get_sample(int x, int y, Color* c, int* obj)
{
	int offset;
	char* Color;
	int* Primitive;

	offset = array_offset(x, y);
	Color = (char*) (offset*3);
	Color = (char*) (Color) + (int)(&main_scene->Color_front[0]);
	Primitive = (int*)(offset * sizeof(int));
	Primitive = (int*)((int)Primitive + (int)(&main_scene->obj_buffer[0]));

	c->r = *Color;
	Color++;
	c->g = *Color;
	Color++;
	c->b = *Color;

	*obj = *Primitive;

}// }}}
*/

/* {{{ get_PrimitiveBase */
/*
 * FIXME: old Primitive buffer function - kill
INLINE int get_PrimitiveBase(int x, int y)
{
	int offset = array_offset(x, y);
	int* Primitive;

	Primitive = (int*)(offset * sizeof(int));
	Primitive = (int*)((int)Primitive + (int)(&main_scene->obj_buffer[0]));

	return *Primitive;

}// }}}
*/
/*
INLINE void get_Color(int x, int y, Color* c)
{
	int offset = array_offset(x, y);
	unsigned char* src_Color;
	src_Color = &main_scene->Color_front[offset*3];

	c->r = *src_Color;
	src_Color++;
	c->g = *src_Color;
	src_Color++;
	c->b = *src_Color;
}
*/

/*
INLINE intersect_data* get_idata(int x, int y)
{
	int offset = array_offset(x, y);
	void *ptr;

	ptr = (void*) (offset*sizeof(intersect_data));
	return &main_scene->intersect_front[offset];
}
 */


