#ifndef BUFFER_H
#define BUFFER_H

#include "../common/scene.h"
#include "../common/Color.h"

extern SlimScene* main_scene;

//void flush_Primitive_buffer();
INLINE void flush_Color_buffer();
//INLINE int array_offset(int x, int y);
INLINE void get_sample(int x, int y, Color* c, int* obj);
//INLINE int get_PrimitiveBase(int x, int y);
//INLINE void get_Color(int x, int y, Color* c);
INLINE intersect_data* get_idata(int x, int y);
//INLINE void set_Color(int x, int y, Color *c);
//INLINE void get_normal(int x, int y, vector3 v);
//INLINE intersect_data* get_idata(int x, int y);
INLINE void clear_idata_buffer();

inline int array_offset(int x, int y)
{
	static int ptr;  //static to avoid redeclaration each call
	//printd(INSANE, "Getting offset for: %i, %i\n", x, y);
	ptr = x + y * main_scene->width;
	return ptr;
}

inline void set_Color(int x, int y, Color *c)
{
	if(x < 0 || y < 0)
		return;
	if(x > main_scene->width-1 || y > main_scene->height-1)
		return;
	int offset = array_offset(x, y);
	char *dest_Color;
	float scale = 1.0f;
	dest_Color = (char*)&main_scene->Color_front[offset * 3];
	
	//printd(INSANE, "Writing Color %i, %i\n", x, y);
	c->toRGB();
	
	*dest_Color = (unsigned char)(c->r*scale);
	dest_Color++;
	*dest_Color = (unsigned char)(c->g*scale);
	dest_Color++;
	*dest_Color = (unsigned char)(c->b*scale);
}


inline void get_Color(int x, int y, Color* c)
{
	int offset = array_offset(x, y);
	unsigned char* src_Color;
	src_Color = &main_scene->Color_front[offset*3];

	c->r = *src_Color;
	src_Color++;
	c->g = *src_Color;
	src_Color++;
	c->b = *src_Color;
}


inline intersect_data* get_idata(int x, int y)
{
	int offset = array_offset(x, y);
	void *ptr;
	
	ptr = (void*) (offset*sizeof(intersect_data));
	return &main_scene->intersect_front[offset];
}




#endif
