#include <stdio.h>
#include <stdarg.h>
#include "../Primitives/PrimitiveBase.h"
#include "scene.h"
#include "debug.h"
#include "../slim.h"
#include "../common/buffer.h"

//#define DEBUG_LEVEL 0
extern int DEBUG_LEVEL;

/*
 * INSANE  = 0 = data out  (rays x y, Colors, etc)
 * CRAZY   = 1 = section id ('entering diffuse lighting', etc)
 * DEBUG   = 2 = function id ('{entering phong', '}exiting intersect', etc)
 * ALERT   = 3 = non repeated info (assumptions, misc info, etc)
 * MESSAGE = 4 = pipeline id (loading scene, model ids, etc)
 * NORMAL  = 5 = status id (fps, errors, etc)
 * FRAME   = 6 = fps + other data
 * QUIET   = 7 = no output
 */

extern SlimScene* main_scene;
extern void (*print_function)(char*, va_list);
extern void (*print_frame_data)(char*, va_list);

INLINE void print_to_stdout(char* msg, va_list args)
{
	vfprintf(stdout, msg, args);
	fflush(stdout);
}

INLINE void print_file(int level, FILE *file, char* msg, ...)
{
	va_list args;
	va_start(args, msg);
	
	printd(level, msg, args);
	vfprintf(file, msg, args);
	
	va_end(args);
}

INLINE void printd(int level, char* msg, ...)
{
	va_list args;
	va_start(args, msg);

	if(DEBUG_LEVEL <= DEBUG_MESSAGE_LEVEL) //wtf? can't use the word 'DEBUG' here
	{
		fflush(stdout);
		vfprintf(stdout, msg, args);
		fflush(stderr);
	}
	else if (level >= DEBUG_LEVEL)
	{
		if(level == FRAME)
			print_frame_data(msg, args);
		else
			print_function(msg, args);
	}
	
	va_end(args);
}

INLINE void print_vector(int level, char* text, vector3& v)
{
	printd(level, text);
	printd(level, "%.2f %.2f %.2f", v[0], v[1], v[2]);
}

INLINE void print_Color(int level, char* text, Color* c)
{
	printd(level, text);
	printd(level, "%.2f, %.2f, %.2f\n", c->r, c->g, c->b);
}


INLINE void print_idata(int level, char *text, intersect_data *i_data)
{

	printd(level, text);
	printd(level, "\n\
\txy: %f,%f\n \
\tstart:%f,%f,%f\n \
\tintersect:%f,%f,%f\n \
\tproj:%f,%f,%f\n \
\tnormal:%f,%f,%f\n \
\treflect:%f,%f,%f\n \
\tstep:%i\n \
\tdistance:%f\n \
\tobj_ptr:%u\n \
\tobj_num:%i\n",
		i_data->pos[0], i_data->pos[1],
		i_data->start[0], i_data->start[1], i_data->start[2],
		i_data->intersect[0], i_data->intersect[1], i_data->intersect[2],
		i_data->proj[0], i_data->proj[1], i_data->proj[2],
		i_data->normal[0], i_data->normal[1], i_data->normal[2],
		i_data->step, i_data->distance, i_data->obj, i_data->obj_num);

}


INLINE void print_PrimitiveBase(int level, char *text, PrimitiveBase *obj)
{
	printd(level, 
"Model[%i], type[%i] - %s\n \
\tpos: %f, %f, %f\n \
\tnormal: %f, %f, %f \
\tradius: %f\n",
		obj->id, obj->obj_type, text,
		obj->pos[0], obj->pos[1], obj->pos[2],
		obj->norm[0], obj->norm[1], obj->norm[2],
		obj->radius);
}

INLINE void print_buffer()
{

	intersect_data* id;
	int i,j;

    for(j=0; j < main_scene->height-main_scene->sub_dis; j++)
    {
        for(i=0; i < main_scene->width-main_scene->sub_dis; i++)
        {
			id = (intersect_data*)get_idata(i,j);
			printd(NORMAL, "%.2f,%.2f,%.2f\t",
					id->normal[0], id->normal[1], id->normal[2]);
        }
			printd(NORMAL, "\n");
    }

}

