#ifndef DEBUG_H
#define DEBUG_H
//#include <stdarg.h>
#include "scene.h"
#include "../Primitives/PrimitiveBase.h"
#include <stdio.h>

#define DEBUG_MESSAGE_LEVEL 2
#define INSANE 1 // many times per function
#define CRAZY 1 // many times per Primitive
#define DEBUG 2 // many times per fame
#define ALERT 3 //once a frame
#define MESSAGE 4 // this is the normal level
#define NORMAL 4
#define FRAME 5
#define QUIET 6
#define WARNING 7
#define ERROR 1000

INLINE void print_to_stdout(char* msg, va_list);
INLINE void printd(int level, char* msg, ...);
INLINE void print_idata(int level, char *text, intersect_data *i_data);
INLINE void print_PrimitiveBase(int level, char *text, PrimitiveBase *obj);
INLINE void print_Color(int level, char* text, Color* c);
INLINE void print_vector(int level, char* text, vector3 &v);
INLINE void print_buffer(void );
INLINE void print_file(int level, FILE *file, char* msg, ...);

#endif /* DEBUG */
