#include "../common/Compatible.h"
#include <stdio.h>
#include "debug.h"
#include "misc.h"
//#include <sys/time.h>

int timeval_to_millisecond(timeval *start, timeval *finish)
{
	long int seconds = finish->tv_sec - start->tv_sec;
	long int microseconds = finish->tv_usec - start->tv_usec;
	
	return (seconds * 1000) + (microseconds / 1000);
}
/*
float time_to_millisecond(clock_t start, clock_t finish)
{
	return ((float)(finish - start)) / TIME_SCALE;
}
*/

#define frameCountSize 5
void print_frame_info(int milliseconds, int rays)
{
	//static int frameCount = 0;
	//static long float totalAverage = 0;
	static int timingBuffer[frameCountSize];
	long double averageTiming = 0;
	
	/*
	frameCount++;
	int diff = milliseconds - totalAverage;
	long float scale = 1.0/frameCount;
	totalAverage = totalAverage + diff * scale;
	*/
	
	//shift buffer
	for(int i=0; i<frameCountSize-1; i++)
		timingBuffer[i] = timingBuffer[i+1];
	
	timingBuffer[frameCountSize-1] = milliseconds;
	
	//add timings
	for(int i=0; i<frameCountSize; i++)
		averageTiming += timingBuffer[i];
	
	averageTiming = averageTiming / frameCountSize;
	
	printd(FRAME, "time:%i\tfps:%.3f\t\n", 
			(int)averageTiming, (float)1000.0f / (int)averageTiming);
}

