#include <stdlib.h>
#include <stdio.h>
#include "../Primitives/PrimitiveBase.h"
#include "../parse/parser.h"
#include "../Primitives/LineSegment.h"
#include "../common/Vector3.h"
#include "../common/Color.h"
#include "scene.h"
#include "debug.h"
#include "scene.h"

extern SlimScene* main_scene;


void scene_add_PrimitiveBase(PrimitiveBase *obj)
{
	obj->id = numberScenePrimitives();
	//printd(NORMAL, "adding Primitive[%i]\n", obj->id);
	//main_scene->models[numberScenePrimitives()] = obj;
	//main_scene->num_Primitives++;
	main_scene->primitives.push_back(obj);
}

PrimitiveBase* getPrimitivePtr(int id)
{
	return main_scene->primitives[id];
	//return main_scene->models[id];
}

void scene_add_light(SlimScene *scene, PrimitiveBase *obj)
{
	obj->id = scene->num_lights;
	//printd(NORMAL, "adding Primitive[%i]\n", obj->id);
	scene->lights[main_scene->num_lights] = obj;
	scene->num_lights++;
}

void add_debug_ray(vector3& start, vector3& end)
{
	Color c;
	LineSegment *line = new LineSegment(4);
	line->pos = start;
	line->norm = end;
	//line->id = main_scene->num_Primitives+1;
	
	line->setup();
	scene_add_PrimitiveBase(line);
	
	c.r = 10000000000000000.0f;
	c.g = 10000000000000000.0f;
	c.b = 10000000000000000.0f;
	line->diff = c;
	line->amb = c;
	line->spec = c;
	line->emit = c;
}

//this is leaky- Primitives can allocate their own memory!
void scene_del_last_PrimitiveBase()
{
	//free(main_scene->primitives[main_scene->num_Primitives]);
	//main_scene->num_Primitives--;
}

int numberScenePrimitives()
{
	//return main_scene->num_Primitives;
	return main_scene->primitives.size();
}
