#ifndef SCENE_H
#define SCENE_H

#include "../common/structs.h"
#include "../Primitives/PrimitiveBase.h"
#include "../common/Color.h"
#include "../slim.h"
#include "list.h"
#include "Vector3.h"
#include "Matrix.h"
#include "../common/Camera.h"
#include "../Hierarchy/HierarchyBase.h"

#define NUM_OBJECTS 1500
#define EXTENSION_LENGTH 15
#define MAX_FILE_SIZE 50000
#define MAX_OBJ_NAME 16

class SlimScene
{
public:
	int current_time;
	int max_recurs;
	int sub_dis; //distance between sub-samples
	int sub_var; //max variance between Colors of samples
	int sub_level; //stop sub-sampling at this level
	int width;
	int height;
	//int num_Primitives;
	int num_lights;
	char filename[NAME_LENGTH];
	char outname[NAME_LENGTH];
	char scene_name[NAME_LENGTH];
	//char extension[EXTENSION_LENGTH];
	
	// FIXME: should these be 2 dimensional arrays? might be slower
	unsigned char* Color_front;
	unsigned char* Color_back;
	unsigned char* misc_buffer;
	intersect_data* intersect_front;
	intersect_data* intersect_back;
	//int* obj_buffer;
	
	PrimitivePtrList primitives;
	PrimitiveBase* lights[30];
	Camera* camera;
	PrimitiveBase* background;
	
	HierarchyBase* hierarchy;
	
	void *photon_map;
	
	/* external modules */
	void* intersect[20];
	void* shader[20];
	void* post_process[20];
	
	intersect_data intrsct;
	int last_render_time;
};

   
void scene_add_PrimitiveBase(PrimitiveBase *obj);
void scene_add_light(SlimScene *scene, PrimitiveBase *obj);
void add_debug_ray(vector3 *start, vector3 *end);
void scene_del_last_PrimitiveBase();
int numberScenePrimitives();
PrimitiveBase* getPrimitivePtr(int id);

#endif /* OBJECTS_H */
