#ifndef STRUCTS_H
#define STRUCTS_H
#include "../Primitives/PrimitiveBase.h"
#include "../common/Color.h"
#include "../slim.h"
#include "list.h"
#include "Vector3.h"
#include "../common/Camera.h"
#include "../Hierarchy/HierarchyBase.h"

/* Primitive types */
#define BACKGROUND 0
#define SPHERE 1
#define PLANE 2
#define DISC 3
#define LIGHT_POINT 4
#define CAMERA 5
#define CYLINDER 6
#define NOTHING 7
#define RECTANGLE 8
#define TRIANGLE 9
#define LIGHT_SPHERE 10
#define LIGHT_SPOT 11
#define LIGHT_INFINITE 12
#define LINE_SEGMENT 13
#define LIGHT_DISC 14

#ifndef EPSILON
#define EPSILON 0.000000001f
#endif

//char module_path[500];


/*
typedef struct
{
	vector3 *vertices[3];
} triangle;

typedef struct
{
	vector3 *points;
	triangle *triangles;
	int num_points;
	int num_triangles;
} model;
*/

//typedef void (*shader_func)(intersect_data *id, Color *new_Color);

/*
typedef struct
{
	int obj_num;
	vector3 start;
	vector3 intersect;
	int step;
} int_data;
*/

/*
typedef struct
{
	PrimitiveBase* obj;
	vector3 intersect;
	vector3 proj;
	vector3 normal;
	vector3 reflect;
	float distance;
} shading_data;
*/

typedef struct
{
	PrimitiveBase* obj;
	vector3 pos;
	int obj_num;
	int other_obj_num;
	vector3 start;
	vector3 intersect;
	vector3 proj;

	vector3 normal;
	//Color new_Color;
	int step;
	float distance;
} intersect_data;

/*
typedef struct
{
	PrimitiveBase* obj;
} buffer_data;
*/


/*
typedef struct
{
	list *options;
	
	void (*set_option) (char *name, void *value);
	void* (*get_option) (char *name);
	
	void (*initialize) (void);
	void (*deinitialize) (void);
	
	void (*render) (int thread_id, int max_num_threads);
} render_engine;
*/

typedef struct
{
	//generic default values
	int max_width;
	int max_height;	
	int default_render;
	int debug_level;

	//buffers
	unsigned char* Color_front;
	unsigned char* Color_back;
	unsigned char* misc_buffer;
	intersect_data* intersect_front;

	//threading
	int max_num_threads;
	
	//shaders
	list fragment_shaders;
	list post_shaders;
	list primatives;
	list render_engines;
	
	//active items
	list active_post_shaders;
	//render_engine *active_render_engine;
} system_data;

#endif /* STRUCTS_H */
