#include <stdlib.h>
#include "SDL/SDL.h"
#include "display_scene.h"
#include "../common/scene.h"
#include "../common/debug.h"
#include "../common/buffer.h"
#include "../misc/save_frame.h"
//#include "../../shader/noise.h"
#include "front_init.h"
#include "handle_input.h"
#include "console.h"
#include <time.h>
//#include <strings.h>
#include "globals.h"
#include "../common/scene.h"

#include "../render/render_scene.h"

//extern clock_t current_time;
extern char frame_break_text[INPUT_COMMAND_LENGTH];

void process_buffer(SlimScene *scene)
{
	//static struct timespec sleeptime;
	
	//sleeptime.tv_sec = 0;
	//sleeptime.tv_nsec = 020000000;

	//if( handle_input() )
	handle_input(); 
		update_buffer(main_scene, frontend->screen);
	//else
	//	nanosleep(&sleeptime, NULL);
}

int display_scene_loop(SlimScene *scene)
{

	printd(CRAZY, "Displaying scene\n");
	while( frontend->running )
	{
		render_scene(frontend->renderer);
		process_buffer(main_scene);
	}

	return 1;
}


int update_buffer(SlimScene *scene, SDL_Surface* screen)
{
	unsigned char* old_buffer;
	Uint32* new_buffer;
	Uint8 R, G, B;
	Uint32 sdl_Color;
	int x,y;
	
	//static struct timespec sleeptime;
	
	//sleeptime.tv_sec = 0;
	//sleeptime.tv_nsec = 100000000;
	
	//if(numberScenePrimitives() < 1)
	//	nanosleep(&sleeptime, NULL);

	printd(CRAZY, "Copying buffer\n");
	old_buffer = scene->Color_front;
	for(y=0; y < scene->height; y++)
	{
		for(x=0; x < main_scene->width; x++)
		{
			printd(INSANE, "Copying Color @ %i, %i\n", x, y);

			R = *old_buffer;
			old_buffer++;
			G = *old_buffer;
			old_buffer++;
			B = *old_buffer;
			printd(INSANE, "%i\n", B);
			old_buffer++;

			printd(INSANE, "Making Color\n");
			sdl_Color = SDL_MapRGB(screen->format, R, G, B);

			printd(INSANE, "Making pointer\n");
			new_buffer = (Uint32*)screen->pixels + y * screen->pitch/4 + x;

			printd(INSANE, "Setting Color\n");
			*new_buffer = sdl_Color;
			//*new_buffer = 0xffff;
			printd(INSANE, "%x,%x,%x -- %x, %x\n", R,G,B,sdl_Color, *new_buffer);
		}
	}
	
	if(frontend->console_on)
	{
		draw_console(screen);
		print_to_bottom(frame_break_text);
	}

	//draw_buttons(screen);
	
	SDL_UpdateRect(frontend->screen, 0,0,0,0);
	
	printd(CRAZY, "Done copying buffer\n");

	return 1;
}

