#include <stdlib.h>
#include <math.h>
#include "SDL/SDL.h"
#include "display_scene.h"
#include "../slim.h"
#include "../common/scene.h"
#include "../common/debug.h"
#include "../common/Vector3.h"
#include "../common/buffer.h"
#include "../common/Color.h"
#include "../render/ray_common.h"
#include "../load/setup_scene.h"
#include <string.h>
#include "../misc/save_frame.h"
#include "front_init.h"
#include "handle_input.h"
#include "globals.h"
#include "console.h"
#include "../parse/parser.h"
#include "../load/setup_scene.h"
#include "../parse/slm_parser.h"
#include "../common/scene.h"

extern void *(*up)();
extern void *(*down)();
extern SlimScene *main_scene;


extern float powder;
extern float air_friction;
extern float bullet_mass;
extern float cannon_azimuth;
extern float cannon_elevation;

extern float spring_mass;
extern float spring_constant;
extern float spring_damp;

extern float bead_mass;
extern float wire_friction;

extern float gravity;
extern float sim_step_size;

extern int current_sim;
extern int sim_type;

extern float tessellation_degree;
extern float max_radius;

extern char command_list[NUM_SAVED_COMMANDS][INPUT_COMMAND_LENGTH];
#define BUTTON_WIDTH GLYPH_WIDTH*5

char shift_on;
char ctrl_on;

int over_button(int x, int y)
{
	if(y > main_scene->height - LINE_HEIGHT-5)
		return 1;
	return 0;
}

int get_button_num(int x)
{
	int val;
	
	if(x> main_scene->width - BUTTON_WIDTH*8)
	{
		val = (x - (main_scene->width - BUTTON_WIDTH*8)) / (BUTTON_WIDTH);
		return val;
	}
	return -1;
}

void change_val(int dir, float *d, char *disc)
{
#define EPS 0.00001

	if(shift_on)
		*d = *d + fabs(*d) * 0.4 * (float)dir;
	else
		*d = *d + fabs(*d) * 0.05 * (float)dir;
		
	if(*d == 0)
		*d = dir * EPS;
	else if(*d < EPS && *d > 0)
		*d = 0;
	else if(*d > -EPS && *d < 0)
		*d = 0;

	printd(NORMAL, disc, *d);
}

void change_val_clamp(int dir, float *d, float min, float max, float delta, char *disc)
{

	*d = *d + delta * (float)dir;
	
	if(*d < min)
		*d = min;
	if(*d > max)
		*d = max;
	
	printd(NORMAL, disc, *d);
}



void handle_front_end_keys(SDL_Event *event)
{
//	static char shift = 0;
	Uint8 *keystate = SDL_GetKeyState(NULL);

	if(event->key.keysym.sym == SDLK_PAGEDOWN)
	{
		history_pos--;
		if(history_pos < 0)
			history_pos = 0;
		return;
	}

	if(event->key.keysym.sym == SDLK_PAGEUP)
	{
		history_pos++;
		if(history_pos > CONSOLE_HISTORY_LINES - 1)
			history_pos = CONSOLE_HISTORY_LINES - 1;
		return;
	}

	if(event->key.keysym.sym == SDLK_UP)
	{
		current_command++;
		if(current_command > NUM_SAVED_COMMANDS - 1)
			current_command = NUM_SAVED_COMMANDS - 1;

		frontend->current_char = strlen(command_list[current_command]);
		return;
	}

	if(event->key.keysym.sym == SDLK_DOWN)
	{
		current_command--;
		if(current_command < 0)
			current_command = 0;

		frontend->current_char = strlen(command_list[current_command]);
		return;
	}		

	if(event->key.keysym.sym == SDLK_BACKQUOTE)
	{
		frontend->console_on = 0;
		return;
	}

	if ( keystate[SDLK_BACKSPACE] || event->key.keysym.sym == SDLK_BACKSPACE)
	{
		frontend->current_char--;
		if(frontend->current_char < 0)
			frontend->current_char = 0;
		command_list[current_command][frontend->current_char] = '\0';
	}

	if(event->key.keysym.sym == SDLK_RETURN)
	{
		//process input
		update_command_list();
		update_console_history(command_list[current_command]);
		printd(ALERT, "%s\n", command_list[current_command]);
		
		process_command_string((char*)&command_list[0]);
		frontend->current_char = 0;
		clear_input_string();
//			input_command[frontend->current_char] = '\0';
	}

	if(event->key.keysym.unicode >= 32 && event->key.keysym.unicode <= 126)
	{
//			if(shift)
//				input_command[current_char] = shifted_char(event->key.keysym.sym);
//			else
			command_list[current_command][frontend->current_char] = tolower(event->key.keysym.unicode);

		frontend->current_char++;
		command_list[current_command][frontend->current_char] = '\0';
		//printd(ALERT, "%i\n", event.key.keysym.sym);
	}
}

void handle_keys(SDL_Event *event)
{
	//static char shift = 0;
	//Uint8 *keystate = SDL_GetKeyState(NULL);
	slimFloat size = main_scene->hierarchy->size();
	
	if(event->key.keysym.sym == SDLK_ESCAPE)
		frontend->running = 0;
	
	if(frontend->console_on)
	{
		handle_front_end_keys(event);
		return;
	}

	//shift_on = 0;
	//if ( keystate[SDLK_LSHIFT] )
	//	shift_on = 1;
	//if ( keystate[SDLK_RSHIFT] )
	//	shift_on = 1;


	switch(event->key.keysym.sym)
	{
//		case SDLK_5:
//			main_scene->lights[0]->pos.c[0] = 
//				main_scene->lights[0]->pos.c[0]+.2;
//			break;
//
//		case SDLK_6:
//			main_scene->lights[0]->pos.c[0] = 
//				main_scene->lights[0]->pos.c[0]-.2;
//			break;
//		case SDLK_2:
//			up();
//			break;
//		case SDLK_1:
//			down();
//			break;	

		case SDLK_UP:
			break;
		case SDLK_DOWN:
			break;
		case SDLK_LEFT:
			break;
		case SDLK_RIGHT:
			break;

		case SDLK_BACKSPACE:
		case SDLK_RSHIFT:
		case SDLK_LSHIFT:
			break;
		
		case SDLK_BACKQUOTE:
			frontend->console_on = 1;
			break;
		
		case SDLK_p:
			save_frame(main_scene);
			break;
		
		case SDLK_a:
			main_scene->camera->pos = main_scene->camera->pos + (main_scene->camera->horz * size * 0.1);
			main_scene->camera->setupCamera();
			break;
		case SDLK_d:
			main_scene->camera->pos = main_scene->camera->pos + (main_scene->camera->horz * -size * 0.1);
			main_scene->camera->setupCamera();
			break;
		case SDLK_w:
			main_scene->camera->pos = main_scene->camera->pos + (main_scene->camera->look * size * 0.1);
			main_scene->camera->setupCamera();
			break;
		case SDLK_s:
			main_scene->camera->pos = main_scene->camera->pos + (main_scene->camera->look * -size * 0.1);
			main_scene->camera->setupCamera();
			break;
		case SDLK_c:
			main_scene->camera->pos = main_scene->camera->pos + (main_scene->camera->up * -size * 0.1);
			main_scene->camera->setupCamera();
			break;
		case SDLK_SPACE:
			main_scene->camera->pos = main_scene->camera->pos + (main_scene->camera->up * size * 0.1);
			main_scene->camera->setupCamera();
			break;
		default:
			break;
	}
}

extern char debug_ray;
void handle_mouse_button(SDL_Event *event)
{
	static char Primitives_before = -1;
	static char Primitives_after = -1;
	intersect_data *id;
	Color c;
	vector3 new_camera_pos;
	char trackball_on = 1;
	//float moveAmount = 30.0f;
	slimFloat size = main_scene->hierarchy->size();

	int old_debug = DEBUG_LEVEL;
	switch(event->button.button)
	{
		case SDL_BUTTON_RIGHT:
			c.clear();
			
			for(int i=Primitives_before; i<Primitives_after; i++)
				scene_del_last_PrimitiveBase();
			
			Primitives_before = numberScenePrimitives();

			debug_ray = 1;
			DEBUG_LEVEL = 0;
			printd(ALERT, "\ndebugging pixel: %i,%i\n", 
					event->button.x, event->button.y);

			id = get_idata(event->button.y, event->button.y);
			calc_ray(event->button.x, event->button.y);
			id->obj->shader(id, &c);
			print_Color(ALERT, "shaded:", &c);

			printd(ALERT, "\n");
			DEBUG_LEVEL = old_debug;
			debug_ray = 0;
			Primitives_after = numberScenePrimitives();
			break;

		case SDL_BUTTON_LEFT:
				frontend->look_on = 1;
			break;
			
		case SDL_BUTTON_WHEELDOWN:
			if (trackball_on)
			{
				new_camera_pos = main_scene->camera->pos - main_scene->camera->lookAtPoint;
				new_camera_pos = new_camera_pos * 1.1;
				main_scene->camera->pos = new_camera_pos + main_scene->camera->lookAtPoint;
			}
			else {
			vector3 t = main_scene->camera->look * -size * 0.1;
				main_scene->camera->pos = main_scene->camera->pos + t;
				t.normalize();
				main_scene->camera->lookAtPoint = main_scene->camera->pos - t;
			}

			break;

		case SDL_BUTTON_WHEELUP:
			if (trackball_on)
			{
				new_camera_pos = main_scene->camera->pos - main_scene->camera->lookAtPoint;
				new_camera_pos = new_camera_pos * 0.9;
				main_scene->camera->pos = new_camera_pos + main_scene->camera->lookAtPoint;
			}
			else {
			vector3 t = main_scene->camera->look *  size * 0.1;
				main_scene->camera->pos = main_scene->camera->pos + t;
				t.normalize();
				main_scene->camera->lookAtPoint = main_scene->camera->pos + t;
			}
			break;
	}
}

void handle_mouse_motion(SDL_Event *event)
{	
	printd(DEBUG, "mouse pos: %i,%i\n mouse rel: %i,%i\n",
		   event->motion.x, event->motion.y,
		   event->motion.xrel, event->motion.xrel);
	
	main_scene->camera->handleInput(event->motion.xrel, event->motion.yrel);
}

bool handle_input()
{
	SDL_Event event;
	Uint8 *keystate = SDL_GetKeyState(NULL);
	bool action = false;
	
	shift_on = 0;
	if(keystate[SDLK_RSHIFT] || keystate[SDLK_LSHIFT])
		shift_on = 1;

	while(SDL_PollEvent(&event))
	{
		if(event.type == SDL_QUIT)
		{
			frontend->running = 0;
			action = true;
		}

		if(event.type == SDL_MOUSEBUTTONDOWN)
		{
			handle_mouse_button(&event);
			action = false;
		}

		if(event.type == SDL_MOUSEBUTTONUP)
		{
			frontend->look_on = 0;
			action = false;
		}
		
		if(event.type == SDL_MOUSEMOTION && frontend->look_on)
		{
			handle_mouse_motion(&event);
			action = false;
		}

		if(event.type == SDL_KEYDOWN)
		{
			handle_keys(&event);
			action = true;
		}
	}
	return action;
}

