//general stuff
#include "../slim.h"

#include "../parse/slm_parser.h"
#include "../parse/obj_slim_converter.h"
#include "../parse/parser.h"
#include "../common/string_extra.h"
#include "./parse_args.h"
#include "./read_scene.h"
//#include "./load_mods.h"
#include "load.h"
#include "./setup_scene.h"
#include "../Primitives/PrimitiveBase.h"
#include "../common/Color.h"
#include "../common/scene.h"
#include "../common/debug.h"
#include <string.h>
#include <stdlib.h>

#include "../common/Vector3.h"

extern int DEBUG_LEVEL;

#define MAX_PATH_LENGTH 1000

//move this to scene Primitive file later
void setup_generic_scene(SlimScene *scene)
{
	//light
	if(scene->lights[0] == NULL)
	{
		/*
		scene->lights[0] = new PrimitiveBase(LIGHT_INFINITE, 0);
		scene->lights[0]->pos = vector3(1, 0.75, 0.34);
		scene->lights[0]->pos.normalize();
		make_color(&scene->lights[0]->amb, 255, 255, 255);
		make_color(&scene->lights[0]->spec, 255, 255, 255);
		make_color(&scene->lights[0]->diff, 255, 255, 255);
		printd(MESSAGE, "Light[%i], type[%i-light] - ok\n",	0, scene->lights[0]->obj_type);
		 */
	}

	//misc
	scene->height = 512;
	scene->width = 512;
	scene->max_recurs = 2;
	scene->sub_dis = 16;
	scene->sub_var = 30;
	scene->sub_level = 1;
}

void setup_generic_camera(SlimScene *scene)
{	
	//camera
	scene->camera->lookAtPoint = vector3(0, 0, 0);
	scene->camera->look = vector3(0, 0, 0);
	scene->camera->pos = vector3(20, 20, 20);
	scene->camera->up = vector3(0, 0, -1);
	printd(MESSAGE, "setting up camera\n");
	//scene->camera->units = 1;
	
	//look at center
	DEBUG_LEVEL = 1;
	scene->camera->lookAtPoint = scene->hierarchy->box.bbMax - scene->hierarchy->box.bbMin;
	scene->camera->lookAtPoint = scene->hierarchy->box.bbMin + scene->camera->lookAtPoint * 0.5;
	
	//camera at the corner
	scene->camera->pos = scene->hierarchy->box.bbMax;
	scene->camera->pos[2] = scene->hierarchy->box.bbMin[2];
	scene->camera->pos *= 1.3;
	
	//look vector
	scene->camera->look = scene->camera->lookAtPoint - scene->camera->pos;
	scene->camera->setupLookPoint();
	
	print_vector(5, "camera pos:", scene->camera->pos);
}

void setup_generic_light(SlimScene* main_scene)
{
	main_scene->lights[0] = new PrimitiveBase(LIGHT_POINT);
	main_scene->lights[0]->pos = main_scene->hierarchy->box.bbMax;
	main_scene->lights[0]->pos[2] = main_scene->hierarchy->box.bbMin[2];
	main_scene->lights[0]->pos *= 1.2;
	main_scene->lights[0]->pos[2] *= 1.8;

	//main_scene->lights[0]->pos = vector3(1, 0.75, 0.34);
	//main_scene->lights[0]->pos.normalize();
	main_scene->lights[0]->amb = Color(255, 255, 255);
	main_scene->lights[0]->spec = Color(500, 500, 500);
	main_scene->lights[0]->diff = Color(255, 255, 255);
	printd(MESSAGE, "Light[%i], type[%i-light] - ok\n",	0, main_scene->lights[0]->obj_type);
}

int init_scene(int argc, char** argv, SlimScene* main_scene)
{
	char path[MAX_PATH_LENGTH];
	
	/* load mods in default dir */

	/* parse the arguemnts */
	printd(2, "parsing the args\n");
	get_scene_path(argc, argv, (char*)&path);
	
	load_scene(path, main_scene);

	return 1;
}

void clean_scene(SlimScene *scene)
{
	int i;

/*	for(i=0; scene->models[i]!=NULL;i++)
	{
		free(scene->models[i]);
		scene->models[i] = NULL;
	}
*/
	for(i=0; scene->lights[i]!=NULL;i++)
	{
		free(scene->lights[i]);
		scene->lights[i] = NULL;
	}
	  
	free(scene->Color_front);
	free(scene->Color_back);
	free(scene->misc_buffer);
	free(scene->intersect_front);
}

void getFileExtension(char *path, char *extensionBuffer)
{
	char *dotPosition;
	
	//get extension
	dotPosition = strrchr(path, '.');
	dotPosition++;
	strncpy(extensionBuffer, dotPosition, EXTENSION_LENGTH);
}

void getFileName(char *path, char *buffer)
{
	char extension[EXTENSION_LENGTH];
	getFileExtension(path, extension);
	strncpy(buffer, path, strlen(path) - strlen(extension) - 1);
}


int load_scene(char *path, SlimScene *main_scene)
{
	char error = 0;
	char extension[EXTENSION_LENGTH];

	strncpy(main_scene->filename, path, NAME_LENGTH);
	
	clean_scene(main_scene);
	getFileExtension(path, extension);
	getFileName(path, main_scene->scene_name);
	
	main_scene->camera->lookAtPoint = vector3(0,0,0);
	main_scene->camera->pos = vector3(0,0,0);

	// load the file into memory
	printd(DEBUG, "reading scene\n");
	printd(MESSAGE , "file type is: %s\n", extension);
	
	//allows the background shader to be set while parsing scene file
	setup_background_PrimitiveBase();
	setup_generic_scene(main_scene);

	if(strequal(extension, "slm"))
		if( parse_slm_scene(main_scene, main_scene->filename) == 0)
			error = 1;
	
	if(strequal(extension, "obj"))
		if( obj_reader_for_slim(main_scene, main_scene->filename) == 0)
			error = 1;

	// this does any pre-render calcs
	printd(2, "setting up scene\n");
	if( setup_scene(main_scene) == 0)
		error = 1;
	
	//if we didn't find a magic camera, set one up
	if(main_scene->camera->lookAtPoint == main_scene->camera->pos)
	{
		printd(ALERT,"No camera setup? Adding a default camera.\n");
		
		setup_generic_camera(main_scene);
		setup_generic_light(main_scene);
		
		DEBUG_LEVEL = 4;
	}

	if(error)
		return 0;

	return 1;
}
