#include "../slim.h"
#include <string.h>
#include <stdio.h>
#include "../common/scene.h"
#include "../common/debug.h"

/* parses the incoming args...  this should be replaced with a
 * unix library later
 */

int get_scene_path(int argc, char** argv, char *path)
{
	strncpy( path, DEFAULT_SCENE, NAME_LENGTH);

	//no path argument
	if(argc == 1)
	{
		printd(5, "Warning- no scene given, trying test.obj...\n", path);
		
		//try to load test.obj
		FILE* test_file;
		test_file = fopen( "test.obj\0", "r");
		if(test_file == 0)
		{
			printd(5, "Could not load test.obj, trying test.slm...\n");
			
			test_file = fopen( "test.slm\0", "r");
			if(test_file == 0)
			{
				printd(5, "Could not load test.obj, trying test.slm...\n");
				strncpy( path, "test.slm\0", NAME_LENGTH);
			}
		}
		else
		{
			strncpy( path, "test.obj\0", NAME_LENGTH);
			fclose(test_file);
		}
	}

	//get path
	else if(argc > 1)
		strncpy( path, argv[1], NAME_LENGTH);

   printd(2, "reading scene from: %s\n", path);

   return 1;
}
