#include "../slim.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "../parse/slm_parser.h"
#include "../parse/obj_parser.h"
#include "../common/scene.h"
#include "../common/debug.h"

int read_file(char *filename, char *out_buffer, int max_size)
{
	FILE* input_file;
	char *out_ptr;
	int new_char = 0;
	int size_count = 0;
	
	//read the file
	input_file = fopen( filename, "r");
	if(input_file == 0)
	{
		printd(5, "Error reading file: %s\n", filename);
		return 0;
	}

	/* copy the file to memory */
	out_ptr = (char*) out_buffer;
	while ( (new_char = getc(input_file)) != EOF && size_count < max_size-2)
	{
		*out_ptr = (char)new_char;
		out_ptr++;
		size_count++;
	}
   *out_ptr = '\0';

   fclose(input_file);

   return 1;
}

