#include "../common/scene.h"
#include "./setup_scene.h"
#include "../Primitives/PrimitiveBase.h"
#include "../common/Vector3.h"
#include "../common/scene.h"
#include "../common/debug.h"
#include "../common/buffer.h"
#include "../shader/shaders.h"
#include "../Primitives/Background.h"
#include "../Hierarchy/FlatList.h"
#include "../Hierarchy/BVH.h"
#include "../Hierarchy/SkipBVH.h"
#include "../Hierarchy/StackBVH.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

extern int DEBUG_LEVEL;

void allocate_buffers()
{
	/* allocated the frame buffers */
	printd(ALERT, "Allocating buffers\n");
    main_scene->Color_front = (unsigned char*) malloc(sizeof(Color) *
			main_scene->width * main_scene->height);

    main_scene->Color_back = (unsigned char*) malloc(sizeof(Color) *
			main_scene->width * main_scene->height);

    main_scene->misc_buffer = (unsigned char*) malloc(sizeof(Color) *
			main_scene->width * main_scene->height);
	
    main_scene->intersect_front = (intersect_data*)
		malloc( sizeof(intersect_data) * main_scene->width *
		main_scene->height);
	main_scene->intersect_back = (intersect_data*)
		malloc( sizeof(intersect_data) * main_scene->width *
		main_scene->height);
}

void setup_background_PrimitiveBase()
{
	if(numberScenePrimitives() > 0)
		return;

	/* set the background Color */
	printd(ALERT, "Creating background Color\n");
	Background *bg = new Background(0);
	bg->shader = (void* (*) (void*, Color*)) (&back_black);
	//bg->shader = (void* (*) (void*, Color*)) (&back_gradiant);
	//main_scene->models[0]->shader = (void* (*) (void*, Color*)) (&back_gray);
	//main_scene->models[0]->intersect =  (float (*) (vector3&, vector3&, void*, vector3&))&intersect_background;
	//main_scene->models[0]->normal =  (vector3 (*) (vector3&, void*, vector3&))&normal_background;
	bg->amb = Color(0, 0, 0 );
	bg->diff = Color(0, 0, 0 );
	bg->spec = Color(0, 0, 0 );
	bg->reflect = 0.0;
	bg->refract_index = 1;
	bg->trans = 0.0;
	
	//scene_add_PrimitiveBase(bg);
	main_scene->background = bg;
	main_scene->num_lights = 0;
}

int setup_scene(SlimScene* scene)
{
	allocate_buffers();
	setup_background_PrimitiveBase();
	main_scene->camera->setupLookPoint();
	
	//printf("scene size: %u\n", main_scene->primitives.size());
	main_scene->hierarchy = new StackBVH();
	//main_scene->hierarchy = new FlatList();
	main_scene->hierarchy->build(main_scene->primitives);
	printd(NORMAL, "Bounding dim: %.2f %.2f %.2f ... ",
		main_scene->hierarchy->box.bbMin[0],
		main_scene->hierarchy->box.bbMin[1],
		main_scene->hierarchy->box.bbMin[2]);
	printd(NORMAL, "%.2f %.2f %.2f\n", 
		   main_scene->hierarchy->box.bbMax[0],
		   main_scene->hierarchy->box.bbMax[1],
		   main_scene->hierarchy->box.bbMax[2]);


	printd(ALERT, "render options\n");
    printd(ALERT, "  sub-distance: %i\n", scene->sub_dis);
    printd(ALERT, "  sub-variance: %i\n", scene->sub_var);
    printd(ALERT, "  sub-max level: %i\n", scene->sub_level);
    printd(ALERT, "  max recursions: %i\n", scene->max_recurs);
    printd(ALERT, "  debug_level: %i\n", DEBUG_LEVEL);

	printd(ALERT, "scene data\n");
	printd(ALERT, "  width: %i, height: %i\n",
			scene->width, scene->height);
	printd(ALERT, "  name: %s, outname: %s\n",
			scene->filename, scene->outname);

	return 1;
}
