#include "./ppm.h"
#include <stdlib.h>
#include <stdio.h>
#include "../common/debug.h"

int write_ppm(char *filename, int width, int height, unsigned char *image)
{
	FILE *outfile;
	outfile = fopen(filename, "w+");

	if(outfile == NULL)
	{
		printd(ALERT, "Error writing ppm file\n");
		return -1;
	}

	fprintf(outfile, "P6\n%i %i\n%i\n", width, height, 255);
	fwrite(image, 1, width*height*3, outfile);
	fclose(outfile);
	return 1;
}
