#include "../common/scene.h"
#include "./bitmapUnix.h"
#include "./ppm.h"
#include "../common/debug.h"
#include <stdio.h>
#include <string.h>

extern SlimScene *main_scene;

void setup_filename(char *extension)
{
	/* set up the filenames */
	printd(ALERT, "Creating outname\n");
	strncpy(main_scene->outname, main_scene->filename, NAME_LENGTH);
	if( strstr(main_scene->filename, ".txt") )
		   main_scene->outname[strlen(main_scene->filename)-4] = '\0';
	if( strstr(main_scene->filename, ".obj") )
		   main_scene->outname[strlen(main_scene->filename)-4] = '\0';
	strcat( main_scene->outname, "_");
	int last_char = strlen(main_scene->outname);
	sprintf( &main_scene->outname[last_char], "%i", main_scene->last_render_time);
	strcat( main_scene->outname, "s");
	strcat( main_scene->outname, extension);
}

int save_frame(SlimScene* scene)
{
	printd(ALERT, "writing file out\n");
	//setup_filename(".ppm");
	//return (int) write_ppm( scene->outname,
	//		scene->width, scene->height, scene->Color_front);

	setup_filename(".bmp");
	return (int) write24BitBmpFile( scene->outname,
			scene->width, scene->height, scene->Color_front);
}
	
