#include "../slim.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "../Primitives/PrimitiveBase.h"
#include "../common/scene.h"
#include "./obj_parser.h"
#include "../common/debug.h"
#include "../shader/shaders.h"
#include "../Primitives/Sphere.h"
#include "../Primitives/Cylinder.h"
#include "../Primitives/Plane.h"
#include "../Primitives/Disc.h"
#include "../Primitives/Rectangle.h"
#include "../Primitives/Triangle.h"
#include "../Primitives/AABB.h"
#include "../shader/lighting.h"
#include "../common/string_extra.h"
#include "../common/Vector3.h"
#include "obj_slim_converter.h"
#include "parser.h"

void assign_obj_Color(Color *c, float o[3])
{
	c->r = o[0] * 255;
	c->g = o[1] * 255;
	c->b = o[2] * 255;
	//c->r = o[0];
	//c->g = o[1];
	//c->b = o[2];
}

void obj_vector_to_slim(vector3& slm, obj_vector *obj)
{
	slm.c[0] = obj->e[0];
	slm.c[1] = obj->e[1];
	slm.c[2] = obj->e[2];
}

void add_obj_material_to_PrimitiveBase( PrimitiveBase *new_Primitive, obj_material **mat_list, int mat_index)
{
	new_Primitive->shader = (void* (*)(void*, Color*))get_shader_ptr("general");
	//new_Primitive->shader = (void* (*)(void*, Color*))get_shader_ptr("shadow_cost");
	new_Primitive->setMisc(0, 0, 0, 0, 100);
	new_Primitive->amb = Color(0.5*255, 0.5*255, 0.5*255);
	new_Primitive->diff = Color(0.5*255, 0.5*255, 0.5*255);
	new_Primitive->spec = Color(0.5*255, 0.5*255, 0.5*255);
	new_Primitive->spec_alpha = 20;
	
	if(mat_index == -1)
		return;

	
	assign_obj_Color(&new_Primitive->amb, mat_list[mat_index]->amb);
	assign_obj_Color(&new_Primitive->diff, mat_list[mat_index]->diff);
	assign_obj_Color(&new_Primitive->spec, mat_list[mat_index]->spec);
	assign_obj_Color(&new_Primitive->spec, mat_list[mat_index]->amb);
	
	//assuming 1000 sharpness is mirror
	new_Primitive->glossy = 1.0f - mat_list[mat_index]->glossy/1000.f;
	new_Primitive->reflect = mat_list[mat_index]->reflect;
	//new_Primitive->refract = mat_list[mat_index]->refract_index;
	new_Primitive->refract_index = mat_list[mat_index]->refract_index;
	new_Primitive->spec_alpha = mat_list[mat_index]->shiny;
	new_Primitive->trans = 1.0f - mat_list[mat_index]->trans;
	
	//print_Color(MESSAGE, "amb: ", &new_Primitive->amb);
	//print_Color(MESSAGE, "diff: ", &new_Primitive->diff);
	//print_Color(MESSAGE, "spec: ", &new_Primitive->spec);
}

void convert_obj_triangle_to_slim(SlimScene *scene, obj_SlimScene *data, obj_face *oo)
{
	vector3 vertices[3];
	Triangle *o = new Triangle(0);
	add_obj_material_to_PrimitiveBase(o, data->material_list, oo->material_index);

	vector3 min = vector3(10000,100000,100000);
	vector3 max = vector3(-10000,-100000,-100000);

	for(int i=0; i<3; i++)
	{
		int vector_index = oo->vertex_index[i];
		obj_vector *v = data->vertex_list[vector_index];
		for(int j=0; j<3; j++)
		{
			vertices[i].c[j] = v->e[j];
			//if(v->e[j] > max[j])
			//	max[j] = v->e[j];
			//if(v->e[j] < min[j])
			//	min[j] = v->e[j];
		}
	}
	
	//AABB *b=new AABB(scene->num_Primitives);
	//add_obj_material_to_PrimitiveBase(b, data->material_list, oo->material_index);
	//b->fromPoints(min, max);
	//scene_add_PrimitiveBase(scene, b);
	o->fromPoints(vertices);
	o->setup();
	scene_add_PrimitiveBase(o);
	
	//print_PrimitiveBase(MESSAGE, "added obj triangle", o);
}

void convert_obj_polygon_to_slim(SlimScene *scene, obj_SlimScene *data, obj_face *oo)
{
	vector3 vertices[3];
	int numTriangles = oo->vertex_count - 2;
	
	for(int pointOffset=0; pointOffset<numTriangles; pointOffset++)
	{
		Triangle *o = new Triangle(0);
		add_obj_material_to_PrimitiveBase(o, data->material_list, oo->material_index);
		
		for(int i=1; i<3; i++)
		{
			int vector_index = oo->vertex_index[pointOffset+i];
			obj_vector *v = data->vertex_list[vector_index];
			for(int j=0; j<3; j++)
			{ vertices[i].c[j] = v->e[j]; }
		}
		
		int vector_index = oo->vertex_index[0];
		obj_vector *v = data->vertex_list[vector_index];
		for(int j=0; j<3; j++)
		{ vertices[0].c[j] = v->e[j]; }

		o->fromPoints(vertices);
		o->setup();
		scene_add_PrimitiveBase(o);
	}
}

void convert_obj_camera_to_slim(SlimScene *scene, obj_SlimScene *data, obj_camera *camera)
{
	if(camera == NULL)
		return;
	
	obj_vector_to_slim(scene->camera->pos, data->vertex_list[camera->camera_pos_index]);
	obj_vector_to_slim(scene->camera->lookAtPoint, data->vertex_list[camera->camera_look_point_index]);
	obj_vector_to_slim(scene->camera->up, data->vertex_normal_list[camera->camera_up_norm_index]);
	scene->camera->look = vector3(scene->camera->lookAtPoint, scene->camera->pos);
	printd(MESSAGE, "setting up camera\n");
}

void convert_obj_light_point_to_slim(SlimScene *scene, obj_SlimScene *data, obj_light_point *oo)
{
	PrimitiveBase *o = new PrimitiveBase(1337);
	o->obj_type=LIGHT_POINT;
	scene_add_light(scene, o);
	add_obj_material_to_PrimitiveBase(o, data->material_list, oo->material_index);
	obj_vector_to_slim(o->pos, data->vertex_list[ oo->pos_index ]);
	print_PrimitiveBase(MESSAGE, "added obj light point", o);
}

void convert_obj_light_disc_to_slim(SlimScene *scene, obj_SlimScene *data, obj_light_disc *oo)
{
	PrimitiveBase *o = new PrimitiveBase(1337);
	o->obj_type=LIGHT_DISC;
	scene_add_light(scene, o);
	add_obj_material_to_PrimitiveBase(o, data->material_list, oo->material_index);
	obj_vector_to_slim(o->pos, data->vertex_list[ oo->pos_index ]);
	obj_vector_to_slim(o->norm, data->vertex_normal_list[ oo->normal_index ] );
	o->radius =  o->norm .length();
	o->norm.normalize();
	
	print_PrimitiveBase(MESSAGE, "added obj light disc", o);
}

void convert_obj_sphere_to_slim(SlimScene *scene, obj_SlimScene *data, obj_sphere *oo)
{
	Sphere *o = new Sphere();
	scene_add_PrimitiveBase(o);
	add_obj_material_to_PrimitiveBase(o, data->material_list, oo->material_index);
	
	obj_vector_to_slim(o->pos, data->vertex_list[ oo->pos_index ]);
	obj_vector_to_slim(o->up, data->vertex_normal_list[ oo->up_normal_index ] );
	obj_vector_to_slim(o->norm, data->vertex_normal_list[ oo->up_normal_index ] );
	o->radius =  o->norm .length();
	
	//print_PrimitiveBase(MESSAGE, "added obj sphere", o);
}

int obj_reader_for_slim(SlimScene *scene, char *filename)
{
	obj_SlimScene data;
	if( !parse_obj_scene(&data, filename) )
		return 0;
	
	if(data.camera != NULL)
		convert_obj_camera_to_slim(scene, &data, data.camera);
	
	for(int i=0; i< data.face_count; i++)
	{
		if(data.face_list[i]->vertex_count == 3)
			convert_obj_triangle_to_slim(scene, &data, data.face_list[i]);
		else if (data.face_list[i]->vertex_count > 3)
			convert_obj_polygon_to_slim(scene, &data, data.face_list[i]);
	}
	for(int i=0; i< data.sphere_count; i++)
		convert_obj_sphere_to_slim(scene, &data, data.sphere_list[i]); 
		
	for(int i=0; i< data.light_disc_count; i++)
		convert_obj_light_disc_to_slim(scene, &data, data.light_disc_list[i]);
		
	for(int i=0; i< data.light_point_count; i++)
		convert_obj_light_point_to_slim(scene, &data, data.light_point_list[i]);
		
	delete_obj_data(&data);
		
	return 1;
}
