#include "../slim.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "../Primitives/PrimitiveBase.h"
#include "./slm_parser.h"
#include "../common/debug.h"
#include "../shader/shaders.h"
#include "../Primitives/Sphere.h"
#include "../Primitives/Cylinder.h"
#include "../Primitives/Plane.h"
#include "../Primitives/Disc.h"
#include "../Primitives/Rectangle.h"
#include "../Primitives/Triangle.h"
#include "../Primitives/LineSegment.h"
#include "../shader/lighting.h"
#include "parser.h"
#include "../load/setup_scene.h"
#include "../common/string_extra.h"
#include "../common/Vector3.h"
#include "../common/scene.h"
#include "../common/Compatible.h"
#include "../load/read_scene.h"

/* loops through the scene file, building scene data structures as it does
 * this function could use a little splitting up
 */

extern int current_sim;
extern int sim_type;
extern int DEBUG_LEVEL;

void* get_shader_ptr(char* shader_name);

int parse_slm_scene(SlimScene* scene, char *filename)
{
	int obj_type = 0;
	float posX = 0;
	float posY = 0;
	float posZ = 0;
	float rotX = 0;
	float rotY = 0;
	float rotZ = 0;
	float ambR = 0;
	float ambG = 0;
	float ambB = 0;
	float specR = 0;
	float specG = 0;
	float specB = 0;
	float diffR = 0;
	float diffG = 0;
	float diffB = 0;
	float emitR = 0;
	float emitG = 0;
	float emitB = 0;
	float upvX = 0;
	float upvY = 0;
	float upvZ = 0;
	float normX = 0;
	float normY = 0;
	float normZ = 0;
	float lookX = 0;
	float lookY = 0;
	float lookZ = 0;
	float radius = 0;
	float dist = 0;
	float spec_alpha = 0;
	float no_shadow = 0;
	float trans = 0;
	float refract = 0;
	float reflect = 0;
	float glossy = 0;
	int width = 0;
	int height = 0;
	int units = 0;
	int max_recurs = 3;
	int sub_dis = 16;
	int antialiasing = 0;
	int sub_var = 10;
	int sub_level = 1;
	char command_string[255];
	char name_string[MAX_OBJ_NAME];
	void* shader_ptr;
	char *token;
	char file_content[MAX_FILE_SIZE];
	
	int linenumber = 0;

	///TERRIBLE HACK
	//allows the background shader to be set while parsing scene file
	setup_background_PrimitiveBase();
	///
	
#define MODELS scene->models
#define LIGHTS scene->lights
#define CAMERA1 scene->camera
	//PrimitiveBase* models[] = &(scene->models);
	//PrimitiveBase* lights[] = scene->lights;
	//camera* scene->camera1;

	char* str;
	int m = 1;  //FIXME: quick hack so 0 can be for the background
	int l = 0;

	int readSuccess = read_file(main_scene->filename, file_content, MAX_FILE_SIZE);
	
	if( !readSuccess )
		return 0;
	str = strtok_r( (char *) file_content, "\n", &token);

	/* while the string is not null parse it */
	do
	{
		shader_ptr = (void*) &general_shader;
		//shader_ptr = &normal_shader;
		/* skip line if it starts with 2 slashes */
		if( strncmp("//", str, 2)==0 || strncmp("#", str, 1)==0)
		{
			continue;
		}

		/* parse for star comments */
		else if( strncmp("/*", str, 2) == 0)
			while( strncmp("*/", strtok_r(NULL, " \t\n", &token), 2)!=0 )
				linenumber++;

		/* process Primitives */
		else if( strcmp(str, "obj_start") == 0)
		{
			strncpy( (char*)name_string, "", 1);
			
			while( (str = strtok_r(NULL, " \n\t", &token)) != NULL &&
				strcmp(str, "obj_end") != 0)
			{
				linenumber++;

				/* Primitive type */
				if( strcmp(str, "obj_type") == 0 )
				{
					str = strtok_r(NULL, " \t\n", &token);
					linenumber++;

					if(strcmp(str, "sphere") == 0)
						obj_type = SPHERE;
					if(strcmp(str, "cylinder") == 0)
						obj_type = CYLINDER;
					else if(strcmp(str, "plane") == 0)
						obj_type = PLANE;
					else if(strcmp(str, "rectangle") == 0)
						obj_type = RECTANGLE;
					else if(strcmp(str, "triangle") == 0)
						obj_type = TRIANGLE;
					else if(strcmp(str, "line_segment") == 0)
						obj_type = LINE_SEGMENT;
					else if(strcmp(str, "disc") == 0)
						obj_type = DISC;
					else if(strcmp(str, "light") == 0)
						obj_type = LIGHT_POINT;
					else if(strcmp(str, "light_spot") == 0)
						obj_type = LIGHT_SPOT;
					else if(strcmp(str, "light_sphere") == 0)
						obj_type = LIGHT_SPHERE;
					else if(strcmp(str, "light_infinite") == 0)
						obj_type = LIGHT_INFINITE;
					else if(strcmp(str, "camera") == 0)
						obj_type = CAMERA;
				}
				/* position */
				else if( strcmp(str, "pos") == 0 )
				{
					posX = atof( strtok_r(NULL, " \t\n", &token));
					posY = atof( strtok_r(NULL, " \t\n", &token));
					posZ = atof( strtok_r(NULL, " \t\n", &token));
					linenumber++;
				}
				/* rotation */
				else if( strcmp(str, "rotation") == 0)
				{
					rotX = atof( strtok_r(NULL, " \t\n", &token));
					rotY = atof( strtok_r(NULL, " \t\n", &token));
					rotZ = atof( strtok_r(NULL, " \t\n", &token));
					linenumber++;
				}
				/* normal vector */
				else if( strcmp(str, "normal") == 0)
				{
					normX = atof( strtok_r(NULL, " \t\n", &token));
					normY = atof( strtok_r(NULL, " \t\n", &token));
					normZ = atof( strtok_r(NULL, " \t\n", &token));
					linenumber++;
				}
				/* look point */
				else if( strcmp(str, "look") == 0)
				{
					lookX = atof( strtok_r(NULL, " \t\n", &token));
					lookY = atof( strtok_r(NULL, " \t\n", &token));
					lookZ = atof( strtok_r(NULL, " \t\n", &token));
					linenumber++;
				}

				/* up vector */
				else if(strcmp(str, "up_vector") == 0)
				{
					upvX = atof( strtok_r(NULL, " \t\n", &token));
					upvY = atof( strtok_r(NULL, " \t\n", &token));
					upvZ = atof( strtok_r(NULL, " \t\n", &token));
					linenumber++;
				}
				/* translucancy */
				else if( strcmp(str, "trans") == 0)
				{
					trans = atof( strtok_r(NULL, " \t\n", &token));
					linenumber++;
				}
				/* refraction */
				else if( strcmp(str, "refract") == 0)
				{
					refract = atof( strtok_r(NULL, " \t\n", &token));
					linenumber++;
				}
				else if( strcmp(str, "glossy") == 0)
				{
					glossy = atof( strtok_r(NULL, " \t\n", &token));
					linenumber++;
				}
				/* reflection */
				else if( strcmp(str, "reflect") == 0)
				{
					reflect = atof( strtok_r(NULL, " \t\n", &token));
					linenumber++;
				}
				/* ambient light */
				else if( strcmp(str, "ambient") == 0)
				{
					ambR = atof( strtok_r(NULL, " \t\n", &token));
					ambG = atof( strtok_r(NULL, " \t\n", &token));
					ambB = atof( strtok_r(NULL, " \t\n", &token));
					linenumber++;
				}
				/* specular light */
				else if( strcmp(str, "specular") == 0)
				{
					specR = atof( strtok_r(NULL, " \t\n", &token));
					specG = atof( strtok_r(NULL, " \t\n", &token));
					specB = atof( strtok_r(NULL, " \t\n", &token));
					linenumber++;
				}
				/* diffuse light */
				else if( strcmp(str, "diffuse") == 0)
				{
					diffR = atof( strtok_r(NULL, " \t\n", &token));
					diffG = atof( strtok_r(NULL, " \t\n", &token));
					diffB = atof( strtok_r(NULL, " \t\n", &token));
					linenumber++;
				}
				/* misc items */
				else if( strcmp(str, "radius") == 0)
				{
					radius = atof( strtok_r(NULL, " \t\n", &token));
					linenumber++;
				}
				else if( strcmp(str, "dist") == 0)
				{
					dist = atof( strtok_r(NULL, " \t\n", &token));
					linenumber++;
				}
				else if( strcmp(str, "spec_alpha") == 0)
				{
					spec_alpha = atof( strtok_r(NULL, " \t\n", &token));
					linenumber++;
				}
				else if( strcmp(str, "no_shadow") == 0)
				{
					no_shadow = atoi( strtok_r(NULL, " \t\n", &token));
					linenumber++;
				}
				else if( strcmp(str, "width") == 0)
				{
					width = (int) atof( strtok_r(NULL, " \t\n", &token));
					linenumber++;
				}
				else if( strcmp(str, "height") == 0)
				{
					height = (int) atof( strtok_r(NULL, " \t\n", &token));
					linenumber++;
				}
				else if( strcmp(str, "max_recurs") == 0)
				{
					max_recurs = (int) atof( strtok_r(NULL, " \t\n", &token));
					linenumber++;
				}
				else if( strcmp(str, "antialiasing") == 0)
				{
					antialiasing = (int) atof( strtok_r(NULL, " \t\n", &token));
					linenumber++;
				}
				else if( strcmp(str, "sub_dis") == 0)
				{
					sub_dis = (int) atof( strtok_r(NULL, " \t\n", &token));
					linenumber++;
				}
				else if( strcmp(str, "sub_var") == 0)
				{
					sub_var = (int) atof( strtok_r(NULL, " \t\n", &token));
					linenumber++;
				}
				else if( strcmp(str, "sub_level") == 0)
				{
					sub_level = (int) atof( strtok_r(NULL, " \t\n", &token));
					linenumber++;
				}
				else if( strcmp(str, "units") == 0)
				{
					units = (int) atof( strtok_r(NULL, " \t\n", &token));
					linenumber++;
				}
				else if( strcmp(str, "parse") == 0)
				{
//					strtok_r(NULL, "\n");
					strncpy((char*)&command_string, strtok_r(NULL, "\n", &token), 255);
					process_command_string((char*)&command_string);
					linenumber++;
					continue;
				}
				else if( strcmp(str, "debug_level") == 0)
				{
					//DEBUG_LEVEL = (int) atof( strtok_r(NULL, " \t\n", &token));
					linenumber++;
				}
				else if( strcmp(str, "shader") == 0)
				{
					shader_ptr = get_shader_ptr(strtok_r(NULL, " \t\n", &token));
					linenumber++;
				}
				else if( strcmp(str, "name") == 0)
				{
					strncpy((char*)&name_string, strtok_r(NULL, " \t\n", &token), MAX_OBJ_NAME);
					linenumber++;
				}
				else if( strncmp("/*", str, 2) == 0)
					while( strncmp("*/", strtok_r(NULL, " \t\n", &token), 2)!=0 )
						linenumber++;
			}

			/* based on the Primitive type, the data is transfered to the 
			 * scene data structure */
			PrimitiveBase *o = NULL;
			switch(obj_type)
			{
				case SPHERE:
					o = new Sphere(m);
					break;
				case CYLINDER:
					o = new Cylinder(m); 
					break;
				case DISC:
					o = new Disc(m);
					break;
				case PLANE:
					o = new Plane(m);
					break;
				case RECTANGLE:
				{
					Rectangle *r = new Rectangle(m);
					r->up = vector3(upvX, upvY, upvZ);
					r->width = radius;
					r->height = o->up.length();
					o = r;
				}
					break;
				case TRIANGLE:
				{
					Triangle *t = new Triangle(m);
					t->pos = vector3(posX, posY, posZ);
					t->norm = vector3(normX, normY, normZ);
					t->up = vector3(upvX, upvY, upvZ);
					t->vertex[0] = t->pos;
					t->vertex[1] = t->up;
					t->vertex[2] = t->norm;
					o = t;
				}
					break;
				case LINE_SEGMENT:
				{
					o = new LineSegment(m);
				}
					break;
				case CAMERA:
//					CAMERA1 = (Camera*) malloc( sizeof(Camera));
					CAMERA1->pos = vector3(posX, posY, posZ);
					CAMERA1->look = vector3(lookX, lookY, lookZ);
					CAMERA1->lookAtPoint = vector3(lookX, lookY, lookZ);
					CAMERA1->up = vector3(upvX, upvY, upvZ);
					printd(MESSAGE, "setting up camera\n");
					scene->width = width;
					scene->height = height;
					scene->max_recurs = max_recurs;
					scene->sub_dis = sub_dis;
					scene->sub_var = sub_var;
					scene->sub_level = sub_level;
					
					main_scene->camera->setupLookPoint();

					printd(MESSAGE, "Camera- ok\n");
					break;
				case LIGHT_POINT:
					LIGHTS[l] = new PrimitiveBase(l);
					LIGHTS[l]->obj_type=LIGHT_POINT;
					LIGHTS[l]->pos = vector3(posX, posY, posZ);
					LIGHTS[l]->amb = Color(ambR, ambG, ambB);
					LIGHTS[l]->spec = Color(specR, specG, specB);
					LIGHTS[l]->diff = Color(diffR, diffG, diffB);
					LIGHTS[l]->emit = Color(emitR, emitG, emitB);
					LIGHTS[l]->setMisc(trans, reflect, refract, radius,
							spec_alpha);

					printd(MESSAGE, "Light[%i], type[%i-light] - ok\n",
							l,LIGHTS[l]->obj_type);

					l++;
					break;
				case LIGHT_SPHERE:
					LIGHTS[l] = new PrimitiveBase(l);
					LIGHTS[l]->obj_type=LIGHT_SPHERE;
					LIGHTS[l]->pos = vector3(posX, posY, posZ);
					LIGHTS[l]->amb = Color(ambR, ambG, ambB);
					LIGHTS[l]->spec = Color(specR, specG, specB);
					LIGHTS[l]->diff = Color(diffR, diffG, diffB);
					LIGHTS[l]->emit = Color(emitR, emitG, emitB);
					LIGHTS[l]->setMisc(trans, reflect, refract, radius,
							spec_alpha);

					printd(MESSAGE, "Light[%i], type[%i-light] - ok\n",
							l,LIGHTS[l]->obj_type);

					l++;
					break;
				case LIGHT_DISC:
					LIGHTS[l] = new PrimitiveBase(l);
					LIGHTS[l]->obj_type=LIGHT_DISC;
					LIGHTS[l]->pos = vector3(posX, posY, posZ);
					LIGHTS[l]->amb = Color(ambR, ambG, ambB);
					LIGHTS[l]->spec = Color(specR, specG, specB);
					LIGHTS[l]->diff = Color(diffR, diffG, diffB);
					LIGHTS[l]->setMisc(trans, reflect, refract, radius,
							spec_alpha);

					printd(MESSAGE, "Light[%i], type[%i-light] - ok\n",
							l,LIGHTS[l]->obj_type);

					l++;
					break;
				case LIGHT_SPOT:
					LIGHTS[l] = new PrimitiveBase(l);
					LIGHTS[l]->obj_type=LIGHT_SPOT;
					LIGHTS[l]->pos = vector3(posX, posY, posZ);
					LIGHTS[l]->norm = vector3(normX, normY, normZ);
					LIGHTS[l]->amb = Color(ambR, ambG, ambB);
					LIGHTS[l]->spec = Color(specR, specG, specB);
					LIGHTS[l]->diff = Color(diffR, diffG, diffB);
					LIGHTS[l]->emit = Color(emitR, emitG, emitB);
					LIGHTS[l]->setMisc(trans, reflect, refract, radius,
							spec_alpha);

					printd(MESSAGE, "Light[%i], type[%i-light] - ok\n",
							l,LIGHTS[l]->obj_type);
					l++;
					break;

				case LIGHT_INFINITE:
					LIGHTS[l] = new PrimitiveBase(l);
					LIGHTS[l]->obj_type=LIGHT_INFINITE;
					LIGHTS[l]->pos = vector3(posX, posY, posZ);
					LIGHTS[l]->pos.normalize();
					LIGHTS[l]->amb = Color(ambR, ambG, ambB);
					LIGHTS[l]->spec = Color(specR, specG, specB);
					LIGHTS[l]->diff = Color(diffR, diffG, diffB);
					LIGHTS[l]->emit = Color(emitR, emitG, emitB);
					printd(MESSAGE, "Light[%i], type[%i-light] - ok\n",	l,LIGHTS[l]->obj_type);
					l++;
					break;
			}
			
			if(o != NULL)
			{
				if( !strequal((char*)&name_string, "") )
					strncpy((char*)&o->name, (char*)&name_string, MAX_OBJ_NAME);
				
				o->pos = vector3(posX, posY, posZ);
				o->amb = Color(ambR, ambG, ambB);
				o->spec = Color(specR, specG, specB);
				o->diff = Color(diffR, diffG, diffB);
				o->emit = Color(emitR, emitG, emitB);
				o->norm = vector3(normX, normY, normZ);
				o->up = vector3(upvX, upvY, upvZ);
				o->glossy = glossy;
				o->setMisc(trans, 0.5, refract,
						   radius, spec_alpha);
				o->shader = (void* (*)(void*, Color*)) shader_ptr;
				//MODELS[m]->intersect =  (float (*)(vector3&, vector3&, void*, vector3&)) &intersect_sphere;
				//MODELS[m]->normal =  (vector3 (*)(vector3&, void*, vector3&)) &normal_sphere;
				//MODELS[m]->inverse_map =  (vector3 (*)(vector3&, void*, vector3&)) &inverse_map_sphere;
				o->no_shadow = no_shadow;
				o->setup();
				scene_add_PrimitiveBase(o);
				o = NULL;
			}
		}

		else
		{
			printd(NORMAL, "Error in scene code at line %i: %s\n",
					linenumber,  str);
			return 0;
		}
	}
	while( str != NULL && (str = strtok_r(NULL, "\n", &token)) != NULL );
	
	main_scene->num_lights = l;
	return 1;
}

