#include "../common/debug.h"
#include "../common/Color.h"
#include "../common/buffer.h"
#include "../common/misc.h"
#include "Rasterizer.h"
#include "../Primitives/Triangle.h"

extern SlimScene* main_scene;
extern void (*update_frame_output)(SlimScene *scene);

vector3 viewportTransform(vector4 &clippedVertex)
{
	vector3 viewVertex;
	//viewport transform
	slimFloat w = main_scene->width;
	slimFloat h = main_scene->height;
	slimFloat offsetX = 0;
	slimFloat offsetY = 0;
	viewVertex[0] = (clippedVertex[0] + 1) * w/2 + offsetX;
	viewVertex[1] = (clippedVertex[1] + 1) * h/2 + offsetY;
	viewVertex[1] = h - viewVertex[1]; //invert opengl y-coord

	return viewVertex;
}

void drawLine(vector3 &p1, vector3 &p2, Color &c)
{
	//this line drawing is slow and incorrect for some points
	//replace with robust version later
	p1 = p1.toInt();
	p2 = p2.toInt();
	bool slopeIsZero = p1[1] == p2[1];
	bool slopeIsUndefined = p1[0] == p2[0];

	if ( slopeIsUndefined )
	{
		int step = 1;
		if (p1[1] > p2[1])
			step = -1;
		for(int i=p1[1]; i!=p2[1]; i+=step)
			set_Color(p1[0], i, &c);
		return;
	}
	else if ( slopeIsZero )
	{
		int step = 1;
		if (p1[0] > p2[0])
			step = -1;
		for(int i=p1[0]; i!=p2[0]; i+=step)
			set_Color(i, p1[1], &c);
		return;
	}

	slimFloat slope = (p1[1] - p2[1]) / (p1[0] - p2[0]);

	if (slope < 1 && slope > -1)
	{
		int step = 1;
		int y = 0;
		if (p1[0] > p2[0])
			step = -1;
		for(int x=p1[0]; x!=p2[0]; x+=step)
		{
			y = slope * (x - p1[0]) + p1[1];
			set_Color(x, y, &c);
		}
		return;
	}
	else if (slope > 1 || slope < -1)
	{
		int step = 1;
		int x = 0;
		if (p1[1] > p2[1])
			step = -1;
		for(int y=p1[1]; y!=p2[1]; y+=step)
		{
			x = (y - p1[1]) / slope + p1[0];
			set_Color(x, y, &c);
		}
		return;
	}
}

void rasterize()
{
	// rasterizer test (no clipping yet)
	//GraphicMatrix proj = main_scene->camera->getProjection();
	GraphicMatrix proj = main_scene->camera->getProjectionFOV();
	//GraphicMatrix proj = main_scene->camera->getFrustum();
	GraphicMatrix look = main_scene->camera->getLookAt();
	GraphicMatrix transform =  proj * look;

	for(unsigned int i= 0; i<main_scene->primitives.size(); i++)
	{
		Triangle *t = dynamic_cast<Triangle*>(main_scene->primitives[i]);
		if( t == NULL)
			continue;

		vector4 v1 = v4fromv3(t->vertex[0]);
		vector4 v2 = v4fromv3(t->vertex[1]);
		vector4 v3 = v4fromv3(t->vertex[2]);
		v1 = transform * v1;
		v2 = transform * v2;
		v3 = transform * v3;
		
		//perspective scaling
		slimFloat perspectiveScale1 = v1[3] == 0.0f ? 1.0 : 1.0f / v1[3];
		slimFloat perspectiveScale2 = v2[3] == 0.0f ? 1.0 : 1.0f / v2[3];
		slimFloat perspectiveScale3 = v3[3] == 0.0f ? 1.0 : 1.0f / v3[3];
		v1 *= perspectiveScale1;
		v2 *= perspectiveScale2;
		v3 *= perspectiveScale3;
		
		//viewport transform
		vector3 vt1 = viewportTransform(v1);
		vector3 vt2 = viewportTransform(v2);
		vector3 vt3 = viewportTransform(v3);
		
		Color r = Color(1000,0,0);
		Color g = Color(0,1000,0);
		Color b = Color(0,0,1000);

		drawLine(vt1, vt2, t->diff);
		drawLine(vt2, vt3, t->diff);
		drawLine(vt3, vt1, t->diff);

		const int pointSize = 1;
		for(int x=0; x<pointSize; x++) {
			for(int y=0; y<pointSize; y++) {
				//set_Color(vt1[0]+x, vt1[1]+y, &t->diff);
				//set_Color(vt1[0]+x, vt1[1]+y, &r);
				//set_Color(vt2[0]+x, vt2[1]+y, &g);
				//set_Color(vt3[0]+x, vt3[1]+y, &b);
			}
		}
		
	}
}
