#include <stdio.h>
#include <time.h>

#include "../Primitives/PrimitiveBase.h"
#include "../common/debug.h"
#include "../common/scene.h"
#include "../common/buffer.h"
#include "../common/Color.h"
#include "../common/misc.h"
//#include "./shading/shader.h"
#include "../common/Vector3.h"
#include "tracer.h"
#include "deferred_renderer.h"
#include "ray_common.h"
#include "../shader/post_shaders.h"

extern SlimScene* main_scene;
void idata_interpolate(int x, int y, int dis);
void deferred_sub_sample(int x, int y, int dis);
int deferred_tile_check(int x, int y, int dis);

/* {{{ deferred_renderer */
void deferred_render()
{
	int distance;
	int i, j;
	Color c;

	c.r = 0;
	c.g = 0;
	c.b = 0;

	distance = main_scene->sub_dis;

	printd(DEBUG, "entering render loop\n");

	//erase last intersect
	clear_idata_buffer();
	flush_Color_buffer();

	//loop to generate the corners of the samples.
	for(j=0; j < main_scene->height-distance; j=j+distance)
	{
		for(i=0; i < main_scene->width-distance; i=i+distance)
		{
			printd(CRAZY, "Sub-sample @  %i %i\n", i, j);
			deferred_sub_sample(i, j, distance);
		}
	}

	//shade the image
	for(j=0; j < main_scene->height-distance; j++)
	{
		for(i=0; i < main_scene->width-distance; i++)
		{
			get_idata(i,j)->obj->shader(
					get_idata(i,j), &c);
			set_Color(i, j, &c);
			c.clear();
		}
	}
}

/* {{{ deferred_sub_sample */
//FIXME: should the distance be looked up from the scene struct instead of
// being passed to each call?
void deferred_sub_sample(int x, int y, int dis)
{
	int dis2 = dis/2;
	int obj;

	printd(CRAZY, "Entering sub sampler: %i, %i, %i\n", x, y, dis);

	//calc corner values if needed
	//FIXME: this needs to be optimized badly
	obj = get_idata(x, y)->obj_num;
	if(obj == NOTHING)
		calc_ray(x, y);
	obj = get_idata(x+dis, y)->obj_num;
	if(obj == NOTHING)
		calc_ray(x+dis, y);
	obj = get_idata(x, y+dis)->obj_num;
	if(obj == NOTHING)
		calc_ray(x, y+dis);
	obj = get_idata(x+dis, y+dis)->obj_num;
	if(obj == NOTHING)
		calc_ray(x+dis, y+dis);

	// FIXME: move down to avoid 1 extra call to this function?
	// changed from 1 to 2
	if(dis < 2)
		return;
	
	//this stops sample when the max sample level is reached
	if(dis < main_scene->sub_level)
	{
		idata_interpolate(x, y, dis);
		return;
	}

	// quit if the we can interpolate
	if(deferred_tile_check(x, y, dis) )
	{
		idata_interpolate(x, y, dis);
		return;
	}

	//recursivly sub-sample
	deferred_sub_sample(x, y, dis2);
	deferred_sub_sample(x+dis2, y, dis2);
	deferred_sub_sample(x, y+dis2, dis2);
	deferred_sub_sample(x+dis2, y+dis2, dis2);

	printd(CRAZY, "Exiting sub sampler\n");
} // }}}

/* {{{ deferred_tile_check */
/* this checks 4 Colors (should be intersects) decides if they are close
 * enough to interpolate */
int deferred_tile_check(int x, int y, int dis)
{
	int obj1, obj2, obj3, obj4;

	printd(CRAZY, "{deferred_tile_check\n");

	obj1 = get_idata(x, y)->obj_num;
	obj2 = get_idata(x+dis, y)->obj_num;
	obj3 = get_idata(x+dis, y+dis)->obj_num;
	obj4 = get_idata(x, y+dis)->obj_num;
	
	// the Primitive number check
	if( obj1 != obj2 || obj1 != obj3 || obj1 != obj4)
	{
		printd(CRAZY,"}deferred_tile_check: objs: %i %i %i %i\n", obj1, obj2, obj3, obj4);
		return 0;
	}

	printd(CRAZY, "}deferred_tile_check: match\n");
	return 1;
} // }}}

/* {{{ interpolate */
/* bi-linearly interpolates the Color of 4 points */
/* this function should be changed to use 4 intersect structs instead of 
 * 4 Colors.  that way, normals, Primitives, and such can be considered */
void idata_interpolate(int x, int y, int dis)
{
	int i,j;
	float horz_dec, vert_dec;   // these values range from one end to zero
	float horz_inc, vert_inc;
	float step;
	float tl_step, tr_step, bl_step, br_step;
	intersect_data* out;
	intersect_data* tl;
	intersect_data* tr;
	intersect_data* bl;
	intersect_data* br;

	tl = get_idata(x, y);
	tr = get_idata(x+dis, y);
	bl = get_idata(x, y+dis);
	br = get_idata(x+dis, y+dis);

	//initializing these to 1.0 and 0.0 instead of 1 and 0 improves
	//rendering time by a noticable amount, due to the fact that 2
	//memory accesses are eliminated for each initialization
	step = 1.0 / (float) dis;
	horz_dec = 1.0;
	vert_dec = 1.0;
	horz_inc = 0.0;
	vert_inc = 0.0;

	printd(CRAZY, "{interpolate: %i\n", dis);

	for(j=0; j<dis; j++)
	{
		for(i=0; i<dis; i++)
		{
			// these are the scales from each of the corners
			// they are pre-calced to make the loop faster
			tl_step = horz_dec*vert_dec;
			tr_step = horz_inc*vert_dec;
			bl_step = horz_dec*vert_inc;
			br_step = horz_inc*vert_inc;
			
			out = get_idata(x+i, y+j);

			out->obj = tl->obj;
			out->obj_num = tl->obj_num;
			out->step = tl->step;
			out->pos.c[0] = x+i;
			out->pos.c[1] = y+j;
			out->start = vector3(tl->start);
			out->distance = main_scene->intrsct.distance;

			//intersect point
			out->intersect.c[0] = 
				tl->intersect.c[0]*tl_step + tr->intersect.c[0]*tr_step +
				bl->intersect.c[0]*bl_step + br->intersect.c[0]*br_step;
			out->intersect.c[1] = 
				tl->intersect.c[1]*tl_step + tr->intersect.c[1]*tr_step +
				bl->intersect.c[1]*bl_step + br->intersect.c[1]*br_step;
			out->intersect.c[2] = 
				tl->intersect.c[2]*tl_step + tr->intersect.c[2]*tr_step +
				bl->intersect.c[2]*bl_step + br->intersect.c[2]*br_step;

//			out->intersect.c[0] = 
//				tl->intersect.c[0];
//			out->intersect.c[1] = 
//				tl->intersect.c[1];
//			out->intersect.c[2] = 
//				tl->intersect.c[2];

			//pojection vector
			out->proj.c[0] = tl->proj.c[0]*tl_step + tr->proj.c[0]*tr_step +
				bl->proj.c[0]*bl_step + br->proj.c[0]*br_step;
			out->proj.c[1] = tl->proj.c[1]*tl_step + tr->proj.c[1]*tr_step +
				bl->proj.c[1]*bl_step + br->proj.c[1]*br_step;
			out->proj.c[2] = tl->proj.c[2]*tl_step + tr->proj.c[2]*tr_step +
				bl->proj.c[2]*bl_step + br->proj.c[2]*br_step;
				
//			out->proj.c[0] = tl->proj.c[0];
//			out->proj.c[1] = tl->proj.c[1];
//			out->proj.c[2] = tl->proj.c[2];

			//normal vector
			out->normal.c[0] = tl->normal.c[0]*tl_step + tr->normal.c[0]*tr_step +
				bl->normal.c[0]*bl_step + br->normal.c[0]*br_step;
			out->normal.c[1] = tl->normal.c[1]*tl_step + tr->normal.c[1]*tr_step +
				bl->normal.c[1]*bl_step + br->normal.c[1]*br_step;
			out->normal.c[2] = tl->normal.c[2]*tl_step + tr->normal.c[2]*tr_step +
				bl->normal.c[2]*bl_step + br->normal.c[2]*br_step;

//			out->normal.c[0] = tl->normal.c[0];
//			out->normal.c[1] = tl->normal.c[0];
//			out->normal.c[2] = tl->normal.c[0];

			horz_inc += step;
			horz_dec -= step;
		}

		horz_inc = 0.0;
		horz_dec = 1.0;
		vert_inc += step;
		vert_dec -= step;
	}
	printd(INSANE, "}interpolate\n");
} //}}}
