#include <stdio.h>
#include <time.h>

#include "../Primitives/PrimitiveBase.h"
#include "../common/debug.h"
#include "../common/scene.h"
#include "../common/buffer.h"
#include "../common/Color.h"
#include "../common/misc.h"
#include "../common/Vector3.h"
#include "tracer.h"
#include "ray_common.h"
#include "sub_sample.h"
#include <stdlib.h>

extern SlimScene* main_scene;

void frameless_subsample_render()
{
	int i, x, y;
	int distance = main_scene->sub_dis;
	printd(DEBUG, "entering render loop\n");

//	flush_Color_buffer();
	clear_idata_buffer();

	for(i=0; i<20; i++)
	{
//		//random points
//		x = (float)rand()/RAND_MAX * (main_scene->width - distance);
//		y = (float)rand()/RAND_MAX * (main_scene->height - distance);

		//grid points
		x = ((float)rand()/RAND_MAX) * (main_scene->width / distance);
		y = ((float)rand()/RAND_MAX) * (main_scene->height / distance);
		printd(CRAZY, "Sub-sample @  %i %i\n", x, y);
		calc_sub_sample(x * distance, y * distance, distance);
	}
}

void random_subsample_render()
{
	int i, x, y;
	int distance = main_scene->sub_dis;
	printd(DEBUG, "entering render loop\n");

//	flush_Color_buffer();
	clear_idata_buffer();

	for(i=0; i<20; i++)
	{
		//random points
		x = (float)rand()/RAND_MAX * (main_scene->width - distance);
		y = (float)rand()/RAND_MAX * (main_scene->height - distance);

		printd(CRAZY, "Sub-sample @  %i %i\n", x, y);
		calc_sub_sample(x, y, distance);
	}
}
