/*
 *  photon_map.cpp
 *  slim
 *
 *  Created by Micah Taylor on 08-11-01.
 *  Copyright 2008 __MyCompanyName__. All rights reserved.
 *
 */

#include <assert.h>
#include "photon_map.h"
#include "../render/tracer.h"
#include "../shader/shaders.h"
#include "../shader/lighting.h"

#include "../common/Compatible.h"

extern char debug_ray;
extern SlimScene* main_scene;

#define magic_number_direct 35.0f
#define magic_number_indirect 20384.0f
#define magic_number_caustic 3000000000.0f
#define DIFFUSE_SAMPLES 5

int _comparePhotonX(void *v1, void *v2)
{
	photonData *p1 = (photonData*)v1;
	photonData *p2 = (photonData*)v2;
	
	if(p1->pos.c[0] < p2->pos.c[0])
		return -1;
	if(p1->pos.c[0] > p2->pos.c[0])
		return 1;
	return 0;
}

int _comparePhotonY(void *v1, void *v2)
{
	photonData *p1 = (photonData*)v1;
	photonData *p2 = (photonData*)v2;
	
	if(p1->pos.c[1] < p2->pos.c[1])
		return -1;
	if(p1->pos.c[1] > p2->pos.c[1])
		return 1;
	return 0;
}

int _comparePhotonZ(void *v1, void *v2)
{
	photonData *p1 = (photonData*)v1;
	photonData *p2 = (photonData*)v2;
	
	if(p1->pos.c[2] < p2->pos.c[2])
		return -1;
	if(p1->pos.c[2] > p2->pos.c[2])
		return 1;
	return 0;
}


inline float cone_filter(float dis, float r)
{
	if(dis < r)
		return 1.0 - dis/r;
	return 0.0;
}

inline float photon_map_attenuate(float distance, char mode)
{
	switch(mode)
	{
		case 1:
			return 100/(50+1*distance+0.0004*pow(distance,2));
		case 2:
			return 60/pow(distance,2);
		case 3:
			return 3/distance;
		case 4:
			return 0.08;
		default:
			return 1.0f;
	}
}

inline void photon_refraction(intersect_data *id, Color *energy)
{
	intersect_data new_id;
	CHECK_STEPS(id->step, main_scene->max_recurs);
	
	if(id->obj->trans > 0 && (id->obj->refract_index != 0.0) ) {
	vector3 refract;
		float reflectAmount = id->proj.refract(refract, id->normal, id->obj->refract_index);
		
		float random = (float) rand()/RAND_MAX;
		
		//reflection
		/*
		if(random < reflectAmount) {
		vector3 rfl;
			reflect_vector(&rfl, &id->proj, &id->normal);
			
			fill_in_next_hit_data(&new_id, id);
			new_id.proj = rfl;
			new_id.obj_num = trace(&new_id.start, &new_id.intersect, &new_id.proj, new_id.step); 
			new_id.obj = main_scene->models[new_id.obj_num];
			new_id.obj->shader(&new_id, energy);
		}
		 */
		
		//refraction
		//else
		{			
			fill_in_next_hit_data(&new_id, id);
			new_id.proj = refract;
			new_id.other_obj_num = RAY_INDIRECT_CAUSTIC;
			if(id->other_obj_num == RAY_DIRECT || id->other_obj_num == RAY_DIRECT_CAUSTIC)
			   new_id.other_obj_num = RAY_DIRECT_CAUSTIC;
			//new_id.obj_num = trace(new_id.start, new_id.intersect, new_id.proj, new_id.step); 
			//new_id.obj = main_scene->models[new_id.obj_num];
			new_id.obj->shader(&new_id, energy);
		}
	}
}

inline void photon_map_diffuse_fast(Color* c, intersect_data* id, int ln)
{
	float dpLN;
	float atten;
	float distance;
vector3 lightV;

	lightV = main_scene->lights[ln]->pos - id->intersect;
	lightV.normalize();
	dpLN = lightV.dot(id->normal.normalize());
	
	// directly behind Primitive
	if (dpLN <= 0)
		dpLN = 0;
	
	distance = main_scene->lights[ln]->pos.distance(id->intersect);
	atten = photon_map_attenuate(distance, 1);
	if(main_scene->lights[ln]->obj_type == LIGHT_INFINITE)
		atten = 1;

	*c = *c + id->obj->diff * dpLN * main_scene->lights[ln]->diff * atten;
}

inline void photon_map_diffuse_light(Color* c, intersect_data* id, int ln)
{
	vector3 lightV;  //vector3 to light from point q
	vector3& intersectP = id->intersect;
	
	lightV = main_scene->lights[ln]->pos - intersectP;
	lightV.normalize();
	photon_map_diffuse_fast(c, id, ln);
	
}

inline void photon_map_specular_light(Color* c, intersect_data* id, int ln)
{
vector3 lightInc;
vector3 lightRefl;
	float dotLight;
	float dotRefl;
	float atten;
	float spec_gamma = id->obj->spec_alpha;
	float distance;
	
	lightInc = main_scene->lights[ln]->pos - id->intersect;
	lightInc.normalize();
	dotLight = lightInc.dot(id->normal.normalize());
	if (dotLight <= 0)
		dotLight = 0;

	distance = main_scene->lights[ln]->pos.distance(id->intersect);
	atten = photon_map_attenuate(distance, 1);

	lightRefl = lightInc.reflect(id->normal);
	id->proj.normalize();
	dotRefl = id->proj.dot( lightRefl);
	if(dotRefl < 0)
		dotRefl = 0;

	*c = id->obj->spec * main_scene->lights[ln]->spec * pow(dotRefl,spec_gamma) * atten * dotLight;
}

inline void photon_map_direct(intersect_data *i_data, Color *new_Color)
{
	int i = 0;
	intersect_data new_id;
	PrimitiveBase *o = i_data->obj;
	Color rfl,rfa,phng,emit;
	phng.clear();
	rfl.clear();
	rfa.clear();
	emit.clear();
	new_Color->clear();
	
	float inside = i_data->proj.dot( i_data->normal)*-1;
	
	//phong lighting
	if(o->diff.componentSum() + o->spec.componentSum() > 0) {
		for(i=0; main_scene->lights[i]!=NULL; i++)
		{
			Color d,s,shadowed_Color;
			d.clear();
			s.clear();
			shadowed_Color.clear();
			
			i_data->other_obj_num = i;
			get_shadow(i_data, &shadowed_Color);
			
			if ( shadowed_Color.r > 0)
			{
				photon_map_diffuse_fast(&d, i_data, i);
				photon_map_specular_light(&s, i_data, i);
			}
			
			d *= shadowed_Color.r;
			s *= shadowed_Color.r;
			phng = phng + (d + s + i_data->obj->emit) * magic_number_direct;
		}
	}
	
	//emission
	if(o->amb.componentSum() > 0)
		emit = o->amb * 255000000.0f;
	
	// adjust for rays falling inside the Primitive
	i_data->intersect = i_data->intersect + i_data->normal*0.05*inside;

	// reflection
	if(i_data->obj->reflect > 0.0f) {
		if(i_data->proj.dot( i_data->normal) < 0) {
			reflect_Color(i_data, &rfl);
			rfl *= i_data->obj->reflect;
		}
	}
	
	// move the intersection for internal Primitive calculations 
	i_data->intersect = i_data->intersect + i_data->normal*-0.1*inside;
	
	// refraction
	if(i_data->obj->trans > 0.0f)
	{
		refract_Color(i_data, &rfa);
		rfa *= i_data->obj->trans;
	}
	
	*new_Color = (phng + rfl + rfa + emit);// * 50.0f;
}





#define debug_stepper 1
void photon_map_store_energy(intersect_data *i_data, Color* incColor)
{
	PrimitiveBase *outsideScene = main_scene->background;
	
	if(i_data->obj == outsideScene)
		return;
	

	CHECK_STEPS(i_data->step, main_scene->max_recurs);
	//hit other side of Primitive, skip
	//if( i_data->proj.dot( i_data->normal) > 1)
	//	return;
	
	//hack for caustics
	if(i_data->step == 0)
		i_data->other_obj_num = RAY_DIRECT;
	
	PhotonMap *pmap = (PhotonMap*)main_scene->photon_map;
	i_data->proj.normalize();
	//if(incColor->r + incColor->g + incColor->b < 0.1)
	//	return;
	//if(incColor->r + incColor->g + incColor->b < 1)
	//	return;
	
	//get_normal(i_data->intersect, i_data->obj, i_data->normal);
	i_data->normal = i_data->obj->normalAtPoint(i_data->intersect);
	i_data->normal.normalize();
	
	float random = (float) rand()/RAND_MAX;
	Color hitDiff = i_data->obj->diff;
	Color hitSpec = i_data->obj->spec;
	float incPower = fmax( fmax(incColor->r, incColor->g), incColor->b );
	float diffuseProb =  fmax( fmax(incColor->r*hitDiff.r, incColor->g*hitDiff.g), incColor->b*hitDiff.b );
	//float specularProb = fmax( fmax(incColor->r*hitSpec.r, incColor->g*hitSpec.g), incColor->b*hitSpec.b );
	float specularProb = i_data->obj->reflect;
	float transmitProb = i_data->obj->trans;
	diffuseProb = diffuseProb / incPower;
	//specularProb = specularProb / incPower;
	
	//diffuse scattering
	if(random < diffuseProb)
	{
		//if(i_data->step >= debug_stepper)
			pmap->addPhoton(i_data, incColor);
		intersect_data rfl_photon;
		Color reflected_Color;
	vector3 temp_v;
		float diffuse_spread = 0.0;
		
		reflected_Color = (*incColor) * ( hitDiff / diffuseProb );
		
		fill_in_next_hit_data(&rfl_photon, i_data);
		rfl_photon.other_obj_num = RAY_INDIRECT;
		temp_v = vector3(i_data->normal);
		temp_v = -temp_v;
		rfl_photon.proj = temp_v.reflectRandom(i_data->normal, diffuse_spread);
		//vector_diffuse_scatter(&rfl_photon.proj, &i_data->normal);
		Ray r = Ray(rfl_photon.start, rfl_photon.proj);
		HitPoint h = HitPoint();
		if( main_scene->hierarchy->rayIntersectAll(r, h) )
		{
			//rfl_photon.obj_num = trace(rfl_photon.start, rfl_photon.intersect, rfl_photon.proj, rfl_photon.step);
			rfl_photon.obj = h.primitivePtr;
			rfl_photon.obj->shader(&rfl_photon, &reflected_Color);
		}
	}
	
	//transmission
	else if(random < diffuseProb+transmitProb)
	{
		intersect_data nextPhoton;
		Color nextColor;
		nextColor = *incColor;
		photon_refraction(i_data, &nextColor);
	}
	//specular reflection
	else if(random < diffuseProb+transmitProb+specularProb)
	{
		intersect_data nextPhoton;
		Color nextColor;		
		nextColor = (*incColor) * 1.0;
		
		fill_in_next_hit_data(&nextPhoton, i_data);
		nextPhoton.proj = i_data->proj.reflect(i_data->normal);
		
		nextPhoton.other_obj_num = RAY_INDIRECT_CAUSTIC;
		if(i_data->other_obj_num == RAY_DIRECT || i_data->other_obj_num == RAY_DIRECT_CAUSTIC)
			nextPhoton.other_obj_num = RAY_DIRECT_CAUSTIC;
		
		//nextPhoton.obj_num = trace(nextPhoton.start, nextPhoton.intersect, nextPhoton.proj, nextPhoton.step);
		//nextPhoton.obj = main_scene->models[nextPhoton.obj_num];
		nextPhoton.obj->shader(&nextPhoton, &nextColor);
	}
	//absorb
	else {
		//if(i_data->step >= debug_stepper)
		//if(i_data->step == 0)
			pmap->addPhoton(i_data, incColor);
	}
	
	return;
}





inline char validPhoton(photonData *p, intersect_data *i_data)
{
	vector3& hit = i_data->intersect;
	vector3& pht = p->pos;
	//return 1;
	
	float c = hit.c[0] - pht.c[0];
	c = c*c;
	if(c>SQ_PHOTON_DIS)
		return 0;
	c = hit.c[1]-pht.c[1];
	c = c*c;
	if(c>SQ_PHOTON_DIS)
		return 0;
	c = hit.c[2]-pht.c[2];
	c = c*c;
	if(c>SQ_PHOTON_DIS)
		return 0;
	
	float dis = hit.distance(p->pos);
	//Color *cpht = &main_scene->models[p->obj_num]->diff;
	//Color *chit = &i_data->obj->diff;
	PrimitiveBase *pobj = p->objPtr;
	PrimitiveBase *hobj = i_data->obj;
	//char c_match = cpht->r == chit->r && cpht->g == chit->g && cpht->b == chit->b;
	char o_match = pobj->norm.dot( hobj->norm) > 0.95f;
	//o_match = (pobj->id == hobj->id);
	
	
	return (o_match && dis < MIN_PHOTON_DIS/* && c_match*/);
}

inline void gather_photons(intersect_data *i_data, Color* outColor)
{
	PhotonMap *pmap = (PhotonMap*) main_scene->photon_map;
	
vector3 incReflect;
	Color sampleColor;
	list foundPhotons;
	list *searchList;
	float scaleColor;
	float min_dis;
	//int found = 0;
	
	outColor->clear();
	incReflect = vector3(i_data->proj);
	//incReflect.normalize();
	
	list_make(&foundPhotons, 1000, 1);
	
	if(i_data->other_obj_num == SEARCH_CAUSTIC_MAP) {
		//searchList = &pmap->caustic_list;
		pmap->ctree->queryTree(&foundPhotons, i_data->intersect, MIN_PHOTON_DIS);
		searchList = &foundPhotons;
	}
	else {
		//searchList = &pmap->photon_list;
		//for(min_dis=5.0f; min_dis<MIN_PHOTON_DIS; min_dis=min_dis+5.0f) {
		//pmap->ptree->queryTree(&foundPhotons, &i_data->intersect, min_dis);
		//if(foundPhotons.item_count >= MIN_PHOTONS_NEEDED)
		//	break;
		//if(min_dis+10.0f >= MIN_PHOTON_DIS)
		//	break;
		//list_delete_all(&foundPhotons);
		//}
		pmap->ptree->queryTree(&foundPhotons, i_data->intersect, MIN_PHOTON_DIS);
		searchList = &foundPhotons;
	}
	
	for(int i=0; i<searchList->item_count; i++)
	{
		photonData *p = (photonData*) list_get_index(searchList, i);
		
		if (validPhoton(p, i_data) )
		{
			sampleColor = p->c * i_data->obj->diff;
			//scaleColor = 1.0;
			//scaleColor = scaleColor * p->incoming.dot( incReflect);			
			if(i_data->other_obj_num == SEARCH_CAUSTIC_MAP) {
				float dis = i_data->intersect.distance(p->pos);
				scaleColor = cone_filter(dis, MIN_PHOTON_DIS);
				sampleColor = sampleColor * scaleColor;
			}
			//if(p->c.r+p->c.g+p->c.b > 1)
			//	sampleColor = p->c * i_data->obj->diff;
			
			*outColor = (*outColor) + sampleColor;
			//found++;
		}
	}
	
	*outColor = (*outColor) * (float)(1.0f/MIN_PHOTON_DIS/M_PI);
	//*outColor = (*outColor) * (float)(1.0f/min_dis/M_PI);
	list_free(&foundPhotons);
}

inline void photon_map_caustic(intersect_data *i_data, Color* outColor)
{
	i_data->other_obj_num = SEARCH_CAUSTIC_MAP;
	gather_photons(i_data, outColor);
	*outColor = *outColor * magic_number_caustic;
}

inline void photon_map_indirect(intersect_data *i_data, Color* outColor)
{
	PrimitiveBase *outsideScene = main_scene->background;
	
	if(i_data->obj == outsideScene)
		return;
	
	int rays_tried;
	
	outColor->clear();
	
	if( i_data->obj->diff.componentSum() < 0.0)
		return;
	
	for(rays_tried = 1; rays_tried <= DIFFUSE_SAMPLES; rays_tried++)
	{	
		intersect_data scatterRay;
		Color scatterColor;
	vector3 temp_v;
#define diffuse_spread 0.1
		//float attenuate = 1.0;
		//float dis = 1.0;
		
		fill_in_next_hit_data(&scatterRay, i_data);
		temp_v = vector3(i_data->normal);
		temp_v = -temp_v;
		//vector_random_reflection(&scatterRay.proj, &temp_v, &i_data->normal, diffuse_spread);
		scatterRay.proj = scatterRay.proj.diffuseScatter(i_data->normal);
		
		//intersect and shade
		scatterColor.clear();
		
		Ray r = Ray(scatterRay.start, scatterRay.proj);
		HitPoint h = HitPoint();
		if( main_scene->hierarchy->rayIntersectAll(r, h) )
		{
			scatterRay.obj = h.primitivePtr;
			//scatterRay.obj_num = trace(scatterRay.start, scatterRay.intersect, scatterRay.proj, scatterRay.step);
			//scatterRay.obj = main_scene->models[scatterRay.obj_num];
			gather_photons(&scatterRay, &scatterColor);
			//dis = distancesq_between(&i_data->intersect, &scatterRay.intersect);
			//attenuate = 1/dis;
			
			//*outColor = *outColor + (scatterColor * attenuate);
			*outColor = *outColor + scatterColor;
		}
	}

	*outColor *= (float)(1.0f/(float)DIFFUSE_SAMPLES);
	*outColor = *outColor * i_data->obj->diff * NUM_TEST_PHOTONS * magic_number_indirect;
}




inline void photon_desity_Color(intersect_data *i_data, Color* outColor)
{
	PhotonMap *pmap = (PhotonMap*) main_scene->photon_map;
	vector3& hit = i_data->intersect;
	list searchList;
	float dis;
	int found = 0;
	
	outColor->clear();
	list_make(&searchList, 30, 1);
	pmap->ptree->queryTree(&searchList, hit, MIN_PHOTON_DIS);
	//	printd(NORMAL, "found: %i\n\n", searchList.item_count);
	
	for (int i=0; i<searchList.item_count; i++) {
		photonData *p = (photonData*) list_get_index(&searchList, i);
		dis = hit.distance(p->pos);
	//	if (validPhoton(p, i_data) )
			{ found++; }
	}

	//false Color shader for density
	static const Color b = Color(0,0,255);
	static const Color r = Color(255,0,0);
	static const Color g = Color(0,255,0);

#define bbottom 0.0f
#define bmid 10.0f
#define btop gmid
#define gbottom bmid
#define gmid 100.0f
#define gtop rmid
#define rbottom gmid
//#define rmid NUM_TEST_PHOTONS / 50.0f
#define rmid 500.0f
#define rtop 1000.0f

	float to_check = (float)found;
	float bs = (to_check > bbottom && to_check < bmid) ? to_check / bmid : 0.0f;
	if (found > bmid && to_check < btop) { bs = (btop - to_check) / (btop - bmid); };
	if (to_check == bmid) bs = 1.0;
	float gs = (to_check > gbottom && to_check < gmid) ? to_check / gmid : 0.0f;
	if (found > gmid && to_check < gtop) { gs = (gtop - to_check) / (gtop - gmid); };
	if (to_check == gmid) gs = 1.0;
	float rs = (to_check > rbottom && to_check < rmid) ? to_check / rmid : 0.0f;
	if (found > rmid && to_check < rtop) { rs = (rtop - to_check) / (rtop - rmid); };
	if (to_check == rmid) rs = 1.0;

	outColor->clear();
	*outColor = b*bs + g*gs + r*rs;
	list_free(&searchList);

	return;
}




void photon_map_get_lighting(intersect_data *i_data, Color* outColor)
{
	intersect_data direct_data, indirect_data, caustic_data;
	Color direct_Color;
	Color indirect_Color;
	Color caustic_Color;
	PrimitiveBase *outsideScene = main_scene->background;
	
	if(i_data->obj == outsideScene)
		return;
	
	//get_normal(i_data->intersect, i_data->obj, i_data->normal);
	i_data->normal = i_data->obj->normalAtPoint(i_data->intersect);
	i_data->normal.normalize();
	
	direct_Color.clear();
	indirect_Color.clear();
	caustic_Color.clear();
	
	//gather_photons(i_data, outColor);
	//*outColor = *outColor * NUM_TEST_PHOTONS * 8000;return;
	//*outColor = *outColor * NUM_TEST_PHOTONS * 20000;return;
	//photon_desity_Color(i_data, outColor); return;

	copy_hit_data(&direct_data, i_data);
	copy_hit_data(&indirect_data, i_data);
	copy_hit_data(&caustic_data, i_data);
	//photon_map_direct(&direct_data, &direct_Color);
	photon_map_indirect(&indirect_data, &indirect_Color);
	//photon_map_caustic(&caustic_data, &caustic_Color);
	*outColor = (indirect_Color + direct_Color + caustic_Color);
}


