#ifndef RAY_COMMON_H
#define RAY_COMMON_H

#include "../common/scene.h"

void generate_subs(void);

void set_Color_PrimitiveBase(int x, int y, Color c, int obj);


#include <stdio.h>
#include <time.h>

#include "../common/Ray.h"
#include "../common/HitPoint.h"
#include "../Primitives/PrimitiveBase.h"
#include "../common/debug.h"
#include "../common/scene.h"
#include "../common/buffer.h"
//#include "../shader/shaders.h"
#include "../common/Vector3.h"
#include "../common/Camera.h"

#include "tracer.h"
#include "ray_common.h"

extern SlimScene* main_scene;
#define CAMERA1 main_scene->camera

extern int DEBUG_LEVEL;
extern inline void calc_ray(float x, float y)
{
	intersect_data i_data;
	//intersect_data* i_data;
	
	//i_data = get_idata((int)(x+0.5), (int)(y+0.5));
	//i_data->start = vector3(CAMERA1->pos);
	//i_data->step=0;
	//i_data->pos.c[0] = x;
	//i_data->pos.c[1] = y;
	
	Ray r = main_scene->camera->getEyeRay(x, y);
	HitPoint h;
	Color c;
	
	if( main_scene->hierarchy->rayIntersectAll(r, h) )
	{
		i_data.obj = h.primitivePtr;
		i_data.proj = r.getDir();
		i_data.intersect = h.pos;
		h.primitivePtr->shader(&i_data, &c);
	}
	else
		main_scene->background->shader(&i_data, &c);

	if ( h.skipShading )
	{
		c.r=h.r;
		c.g=h.g;
		c.b=h.b;
	}
	
	set_Color(x, y, &c);
}


#endif
