#include <stdlib.h>
#include "SDL/SDL.h"
#include "../common/scene.h"
#include "../common/debug.h"
#include "../common/buffer.h"
#include "../common/misc.h"
#include "../misc/save_frame.h"
//#include "../../shader/noise.h"
#include "../common/Timer.h"
//#include "globals.h"
#include "../render/frameless.h"
#include "../render/frameless_subsample.h"
#include "../render/sub_sample.h"
#include "../render/super_sampler.h"
#include "../render/deferred_renderer.h"
#include "../render/normal_renderer.h"
#include "../render/Rasterizer.h"
#include "../shader/post_shaders.h"
#include "../render/photon_map.h"


#include <math.h>

void render_thread(int engine);

//extern clock_t current_time;
extern int intersects_calced;
extern SlimScene* main_scene;


extern float tessellation_degree;
extern float max_radius;
extern float min_radius;
extern int num_balls;
extern int num_interations;
extern float total_time;

void render_scene(int engine)
{
	static Timer renderTime;
	timeval t;
	gettimeofday(&t, NULL);
	long int seconds = t.tv_sec*1000;
	long int milliseconds = t.tv_usec/1000;
	main_scene->current_time = seconds + milliseconds;
	
	//moving light
	static char dir = 1;
	float maxX = main_scene->hierarchy->box.bbMax[0]*1.2;
	float minX = main_scene->hierarchy->box.bbMin[0]*1.2;
	static float amountPerMs = (maxX - minX)/10000.0f;
	if (main_scene->lights[0]->pos.c[1] > maxX || main_scene->lights[0]->pos.c[1] < minX)
		amountPerMs=amountPerMs*-1;
	main_scene->lights[0]->pos.c[1] += main_scene->last_render_time*amountPerMs;
	

	if(engine != 4 && engine != 5 && engine != 6)
	{
		flush_Color_buffer();
		clear_idata_buffer();
	}

	renderTime.start();
	
	render_thread(engine);
	run_post_shaders();
	run_post_shaders_old();
	
	renderTime.stop();

	main_scene->last_render_time = renderTime.inMilliseconds();
	print_frame_info(main_scene->last_render_time, intersects_calced);

	intersects_calced = 0;
	//save_frame(main_scene);
	
	//return;
}


void render_thread(int engine)
{
	/*
	srand(1);
	PhotonMap p;
	p.createMap(main_scene, 5000);
	p.balanceMap();
	
#define xmin 0
#define xmax 350
	static int dir = 1;
	if (main_scene->lights[0]->pos.c[1] > xmax || main_scene->lights[0]->pos.c[1] < xmin)
		dir=dir*-1;
	main_scene->lights[0]->pos.c[1] += 7*dir;
	// reseed random numbers
	timeval t;
	gettimeofday(&t, NULL);
	srand(t.tv_sec * t.tv_usec);
	 */
	
	switch(engine)
	{
		case 0:
			subsample_render(0, main_scene->height);
			break;
		case 1:
			normal_render();
			break;
		case 2:
			deferred_render();
			break;
		case 4:
			frameless_render(0, main_scene->height);
			break;
		case 5:
			frameless_subsample_render();
			break;
		case 6:
			random_subsample_render();
			break;
		case 7:
			super_sampler_render();
			break;
		case 8:
			rasterize();
			break;
		case 13:
			// null render
			break;
			
		default:
			//subsample_render(0, main_scene->height);
			//rasterize();
			normal_render();
			//super_sampler_render();
	}
}

