#include <time.h>
#include <stdlib.h>
#include "../common/debug.h"
#include "../common/Color.h"
#include "../common/buffer.h"
#include "super_sampler.h"
#include "ray_common.h"
#include "tracer.h"
#include "../shader/post_shaders.h"
#include "../common/misc.h"
#include "../common/Vector3.h"
#include "../misc/save_frame.h"

extern SlimScene* main_scene;
extern void (*update_frame_output)(SlimScene *scene);

#define NUM_SAMPLES 9
#define sampler sample_row_jitter
#define get_filter_weight box_filter

void sample_row_random(int j, list *row)
{
	int i, k;
	intersect_data *id;
	Color c;
	float new_x, new_y;
	
	for(i=0; i<main_scene->width; i++)
	{
		id = (intersect_data*)get_idata(i,j);
		for(k=0; k<NUM_SAMPLES; k++)
		{
			new_x = (float)i + ((float)rand()/RAND_MAX*1.0 - 0.5);
			new_y = (float)j + ((float)rand()/RAND_MAX*1.0 - 0.5);
			calc_ray(new_x, new_y);
			id->obj->shader(id, &c);
			sample_data *sample = (sample_data*)malloc(sizeof(sample_data));
			sample->c = c;
			sample->pos.c[0] = new_x;
			sample->pos.c[1] = new_y;
			sample->pos.c[2] = 0;
			list_add_item(&row[i], sample, NULL);
			c.clear();
		}
	}
}

void sample_row_jitter(int j, list *row)
{
	int i, k, m;
	intersect_data *id;
	Color c;
	float new_x, new_y;
	
	for(i=0; i<main_scene->width; i++)
	{
		id = (intersect_data*)get_idata(i,j);
		for(k=-1; k<2; k++)
			for(m=-1; m<2; m++)
			{
				new_x = i+m*0.3333 + ((float)rand()/RAND_MAX*0.3333-0.15);
				new_y = j+k*0.3333 + ((float)rand()/RAND_MAX*0.3333-0.15);
				calc_ray(new_x, new_y);
				id->obj->shader(id, &c);
				sample_data *sample = (sample_data*)malloc(sizeof(sample_data));
				sample->c = c;
				sample->pos.c[0] = new_x;
				sample->pos.c[1] = new_y;
				sample->pos.c[2] = 0;
				list_add_item(&row[i], sample, NULL);
				c.clear();
			}
	}
}

void sample_row_uniform(int j, list *row)
{
	int i, k, m;
	intersect_data *id;
	Color c;
	float new_x, new_y;
	
	for(i=0; i<main_scene->width; i++)
	{
		id = (intersect_data*)get_idata(i,j);
		for(k=-1; k<2; k++)
			for(m=-1; m<2; m++)
			{
				new_x = i+m*0.3333;
				new_y = j+k*0.3333;
				calc_ray(new_x, new_y);
				id->obj->shader(id, &c);
				sample_data *sample = (sample_data*)malloc(sizeof(sample_data));
				sample->c = c;
				sample->pos.c[0] = new_x;
				sample->pos.c[1] = new_y;
				sample->pos.c[2] = 0;
				list_add_item(&row[i], sample, NULL);
			}
	}
}

float box_filter(float xdis, float ydis, float r)
{
	if(xdis < r && ydis < r)
		return 1.0;
	return 0.0;
}

float triangle_filter(float xdis, float ydis, float r)
{
	float dis = sqrt(xdis*xdis + ydis*ydis);
	if(xdis < r && ydis < r)
		return 1.0 - dis/r;
	return 0.0;
}

float quadratic_filter(float xdis, float ydis, float r)
{
	float dis = sqrt(xdis*xdis + ydis*ydis);
	if(xdis < r && ydis < r)
		return 1.0 - pow(dis,2)/pow(r,2);
	return 0.0;
}

float gaussian_filter(float xdis, float ydis, float r)
{
	float dis = sqrt(xdis*xdis + ydis*ydis);
	float e = exp(- pow(dis,2)/(2*pow(r,2)) );
	float c = 1/(sqrt(2*M_PI)*r);
	return c*e;
}

void reconstruct(list **row, int row_index)
{
	int col_index, sample_index, offset_col, offset_row, offset;
	Color accum, c;
	sample_data *sample;
	float scale;
	float xdis, ydis, weight;
	vector3 center;
	float filter_size = 0.6;
			
	for(col_index=1; col_index<main_scene->width-1; col_index++)
	{
		center.c[0] = col_index;
		center.c[1] = row_index;
		center.c[2] = 0.0;
		
		scale = 0.0;
		accum.clear();
		
		for(offset_row=0; offset_row<3; offset_row++)
		{
			for(offset=-1; offset<2; offset++)
			{
				offset_col = col_index+offset;
				for(sample_index=0; sample_index<NUM_SAMPLES; sample_index++)
				{
					sample = (sample_data*)list_get_index(&row[offset_row][offset_col], sample_index);
					c = sample->c;
					xdis = fabs(sample->pos.c[0] - center.c[0]);
					ydis = fabs(sample->pos.c[1] - center.c[1]);
					weight = get_filter_weight(xdis, ydis, filter_size);
					c *= weight;
					scale += weight;
					accum += c;
				}
			}
		}
		
		accum *= (float)1.0/scale;
		set_Color(col_index, row_index, &accum);
	}
}

void delete_row_samples(list *row)
{
	int i, k;
	for(i=0; i<main_scene->width; i++)
	{
		for(k=0; k<NUM_SAMPLES; k++)
		{
			sample_data *s = (sample_data*)list_get_index(&row[i], k);
			free( s );
		}
		
		list_delete_all(&row[i]);
	}
}

void super_sampler_render()
{
	int i, j;
	list **row;
	list *temp_list;
	
	row = (list**) malloc(sizeof(list*)*3);
	row[0] = (list*) malloc(sizeof(list)*main_scene->width);
	row[1] = (list*) malloc(sizeof(list)*main_scene->width);
	row[2] = (list*) malloc(sizeof(list)*main_scene->width);
	
	for(i=0; i<main_scene->width; i++)
	{
		list_make(&row[0][i], NUM_SAMPLES, 1);
		list_make(&row[1][i], NUM_SAMPLES, 1);
		list_make(&row[2][i], NUM_SAMPLES, 1);
	}

	j = 0;
	sampler(j, row[0]);
	j = 1;
	sampler(j, row[1]);
	j = 2;
	sampler(j, row[2]);
	
	for(j=1; j<main_scene->height-1; j++)
	{
		reconstruct(row, j);
		
		if(j % 10 == 0)
			update_frame_output(main_scene);

		delete_row_samples(row[0]);
		

		temp_list = row[0];
		row[0] = row[1];
		row[1] = row[2];
		row[2] = temp_list;

		sampler(j, row[2]);
	}
}
