#include <math.h>
#include <time.h>
#include "../common/Vector3.h"
#include "shaders.h"
#include "phong.h"
#include "../render/tracer.h"
#include "../common/scene.h"
#include "../common/Color.h"
#include "../common/debug.h"
#include "../common/misc.h"


#include <stdio.h>


extern SlimScene* main_scene;
//extern clock_t current_time;
int skip_Primitive;

// general_shader {{{
void general_shader(intersect_data *i_data, Color* final_Color)
{
	Color new_Color;
	intersect_data new_id;
	
	//CHECK_STEPS(i_data->step, main_scene->max_recurs);
	
	final_Color->clear();
	skip_Primitive = i_data->obj_num;
	//get_normal(i_data->intersect, i_data->obj, i_data->normal);
	i_data->normal = i_data->obj->normalAtPoint(i_data->intersect);
	i_data->normal.normalize();
	if(i_data->normal.dot(i_data->proj) > 0.0f)
		return;

	// adjust for rays falling inside the Primitive
	i_data->intersect.c[0] += i_data->normal.c[0]*0.1;
	i_data->intersect.c[1] += i_data->normal.c[1]*0.1;
	i_data->intersect.c[2] += i_data->normal.c[2]*0.1;
	
	//wavy normals for the ducky's water
	if(i_data->obj->reflect > 0.0f)
	{
		float dist = i_data->intersect.distance(i_data->obj->pos);
		vector3 bend = vector3(i_data->intersect, i_data->obj->pos); 
		bend = bend * cos(3*(dist-main_scene->current_time/3000.0f)) * 0.02;
		i_data->normal += bend;
	}

	// phong
	copy_hit_data(&new_id, i_data);
	new_Color.clear();
	phong(&new_id, &new_Color);
	*final_Color += new_Color;

	// reflection

	if(new_id.obj->glossy > 0.0f && new_id.obj->reflect > 0.0f)
	{
		copy_hit_data(&new_id, i_data);
		new_Color.clear();
		glossy_reflect_Color(&new_id, &new_Color);
		//multiply_Color(final_Color, (1.0 - new_id.obj->reflect)); 
		new_Color *= new_id.obj->reflect;
		*final_Color *= 1.0f - new_id.obj->reflect;
		*final_Color += new_Color;
		new_Color.clear();
	}
	else if(new_id.obj->reflect > 0.0f)
	{
		copy_hit_data(&new_id, i_data);
		new_Color.clear();
		reflect_Color(&new_id, &new_Color);
		//multiply_Color(final_Color, (1.0 - new_id.obj->reflect)); 
		//new_Color *= new_id.obj->reflect;
		//*final_Color *= 1.0f - new_id.obj->reflect;
		*final_Color += new_Color;
		new_Color.clear();
	}
	//i_data->step--;
	
/*
	// move the intersection for internal Primitive calculations 
	i_data->intersect.c[0] -= i_data->normal.c[0]*0.05;
	i_data->intersect.c[1] -= i_data->normal.c[1]*0.05;
	i_data->intersect.c[2] -= i_data->normal.c[2]*0.05;
	
	// transparency
	copy_hit_data(&new_id, i_data);
	new_Color.clear();
	trans_Color(&new_id, &new_Color);
	multiply_Color(final_Color, (1 - new_id.obj->trans));
	multiply_Color(&new_Color, new_id.obj->trans);
	add_Colors(final_Color, &new_Color);
	new_Color.clear();

	// refraction 
	copy_hit_data(&new_id, i_data);
	new_Color.clear();
	refract_Color(&new_id, &new_Color);
	add_Colors(final_Color, &new_Color);
	new_Color.clear();
	 */
	
	skip_Primitive = -1;
	return;
}

// wave_shader {{{
void wave_shader(intersect_data *i_data, Color* final_Color)
{
	Color new_Color;
	float dist = 0.0;
vector3 bend;
	//intersect_data new_id;
	
	CHECK_STEPS(i_data->step, main_scene->max_recurs);

	new_Color.clear();

	// create the intersection data structure 
	//get_normal(i_data->intersect, i_data->obj, i_data->normal);
	i_data->normal = i_data->obj->normalAtPoint(i_data->intersect);
	i_data->normal.normalize();


	//setup the bumpy surface
	//new_id.start = vector3(id->intersect);
	//new_id.proj = vector3(id->proj);
	dist = i_data->intersect.distance(i_data->obj->pos);
	bend = vector3(i_data->intersect, i_data->obj->pos); 

	//bend = bend * sin(dist+current_time/TIME_SCALE);
	bend = bend * 0.7;
	bend = i_data->normal + bend;

	// adjust for rays falling inside the Primitive 
	i_data->intersect.c[0] += i_data->normal.c[0]*0.01;
	i_data->intersect.c[1] += i_data->normal.c[1]*0.01;
	i_data->intersect.c[2] += i_data->normal.c[2]*0.01;

	// phong 
	phong(i_data, &new_Color);
	*final_Color += new_Color;

	// reflection 
	reflect_Color(i_data, &new_Color);
	//multiply_Color(final_Color, (1 - i_data->obj->reflect));
	new_Color *= i_data->obj->reflect;
	*final_Color += new_Color;

	// move the intersection for internal Primitive calculations 
	i_data->intersect.c[0] -= i_data->normal.c[0]*0.05;
	i_data->intersect.c[1] -= i_data->normal.c[1]*0.05;
	i_data->intersect.c[2] -= i_data->normal.c[2]*0.05;

	// sintransparency 
	bend = i_data->proj + bend;
	trans_Color(i_data, &new_Color);
	//sin_filter(i_data, &new_Color);
	//multiply_Color(final_Color, (1 - i_data->obj->trans));
	new_Color *= i_data->obj->trans;
	*final_Color += new_Color;

	print_Color(INSANE, "Color:", final_Color);
	printd(DEBUG, "}wave_shader\n");
	return;
}


void distance_shader(intersect_data *i_data, Color* final_Color)
{
	//float dis = main_scene->intrsct.distance;
	slimFloat dis = main_scene->camera->pos.distance(i_data->intersect);

	slimFloat range[2] = {0.0, 1000};
	slimFloat mid[3] = {5.0, 50.0, 500.0};


	final_Color->r = 10;
	final_Color->g = 10;
	final_Color->b = 10;

	if(dis < 20)
		final_Color->r = (char)(dis/20*256);
	if(dis > 19 && dis < 200)
		final_Color->g = (char)(dis/200*256);
	if(dis > 199 && dis < 2000)
		final_Color->b = (char)(dis/2000*256);

	*final_Color = ColorBand(range, mid, dis);
}

void Primitive_shader(intersect_data *i_data, Color* final_Color)
{
	*final_Color = Color((int)i_data->obj);
}

void normal_shader(intersect_data *i_data, Color* final_Color)
{
	//FIXME:normal also is calced in ray_common, kill one
	//get_normal(i_data->intersect, i_data->obj, i_data->normal);
	i_data->normal = i_data->obj->normalAtPoint(i_data->intersect);
	i_data->normal.normalize();

	final_Color->r = (i_data->normal.c[0]*128+128);
	final_Color->g = (i_data->normal.c[1]*128+128);
	final_Color->b = (i_data->normal.c[2]*128+128);}

void relative_normal_shader(intersect_data *i_data, Color* final_Color)
{
	float dot = 0;
	//FIXME:normal also is calced in ray_common, kill one
	//get_normal(i_data->intersect, i_data->obj, i_data->normal);
	i_data->normal = i_data->obj->normalAtPoint(i_data->intersect);
	i_data->normal.normalize();

	i_data->proj.normalize();
	dot = -i_data->normal.dot( i_data->proj);

	final_Color->r = (dot*128+128);
	final_Color->g = (dot*128+128);
	final_Color->b = (dot*128+128);
}

void checker_shader(intersect_data *i_data, Color* final_Color)
{
	Color new_Color;
vector3 dist;

	printd(DEBUG, "{wave_shader\n");

	new_Color.r = 0;
	new_Color.g = 0;
	new_Color.b = 0;

	i_data->step++;
	CHECK_STEPS(i_data->step, main_scene->max_recurs);

	// create the intersection data structure 
	//get_normal(i_data->intersect, i_data->obj, i_data->normal);
	i_data->normal = i_data->obj->normalAtPoint(i_data->intersect);
	i_data->normal.normalize();
	
	dist = vector3(i_data->obj->pos, i_data->intersect);
	
	// adjust for rays falling inside the Primitive 
	i_data->intersect.c[0] += i_data->normal.c[0]*0.01;
	i_data->intersect.c[1] += i_data->normal.c[1]*0.01;
	i_data->intersect.c[2] += i_data->normal.c[2]*0.01;

	if( (int)(floor(dist.c[0]) + floor(dist.c[2])) % 2 == 0)
		*final_Color = Color(1,1,1);
	else
		*final_Color = Color(255,255,255);

	// phong
	phong(i_data, &new_Color);
	*final_Color += new_Color;

	// reflection
	intersect_data new_id;
	fill_in_next_hit_data(&new_id, i_data);
	new_Color.clear();
	if(new_id.obj->glossy > 0.0f && new_id.obj->reflect > 0.0f)
		glossy_reflect_Color(&new_id, &new_Color);
	else if(new_id.obj->reflect > 0.0f)
		reflect_Color(&new_id, &new_Color);
	//multiply_Color(final_Color, (1.0 - new_id.obj->reflect)); 
	new_Color *= new_id.obj->reflect;
	*final_Color *= 1 - new_id.obj->reflect;
	*final_Color += new_Color;
	new_Color.clear();
}

