#include <math.h>
#include <time.h>
#include <stdlib.h>
#include "shaders.h"
#include "../common/Vector3.h"
#include "../render/tracer.h"
#include "../common/scene.h"
#include "../common/Color.h"
#include "../common/debug.h"
#include "../common/misc.h"

#include "lighting.h"

extern int DEBUG_LEVEL;
//extern clock_t current_time;
extern SlimScene* main_scene;

void back_black(intersect_data *id, Color *bg)
{
	bg->r = 0;
	bg->g = 0;
	bg->b = 0;
}

void back_gray(intersect_data *id, Color *bg)
{
	bg->r = 150;
	bg->g = 150;
	bg->b = 150;
}

void back_gradiant(intersect_data *id, Color *bg)
{
	bg->r = (id->pos.c[0] + id->pos.c[1]) / 3;  //gradiant
	bg->g = (id->pos.c[0] + id->pos.c[1]) / 3;
	bg->b = (id->pos.c[0] + id->pos.c[1]) / 3;
}


void purple_gradiant(intersect_data *id, Color *bg)
{
	bg->r = (id->pos.c[0] + id->pos.c[1]) / 3 * 0.1;  //gradiant
	bg->g = (id->pos.c[0] + id->pos.c[1]) / 3 * 0;
	bg->b = (id->pos.c[0] + id->pos.c[1]) / 3 * 0.3;
}

void back_mountains(intersect_data *id, Color *bg)
{
	#define num_mountains 20
	float cosY;
	float cosX;
vector3 y_axis;
vector3 x_axis;
	int first_mountain;
	int second_mountain;
	float projHeight = 0.20;
	float mountainHeight;
	float percent;
	float mountains[num_mountains] = {0.23, 0.87, 0.65, 0.11, 0.45, 0.185, 0.48, 0.8684,
		0.4183, 0.3285, 0.973, 0.371, 0.4, 0.7113, 0.99285, 0.37, 0.576, 0.48, 0.013, 0.8856};

	y_axis = vector3(0., 1., 0.);
	x_axis = vector3(1., 0., 0.);
	
	id->proj.normalize();
	
	//nice sunset gradiant
	cosY = id->proj.dot(y_axis);
	bg->r = (1-cosY)*255;
	bg->g = (1-cosY)*100;
	bg->b = cosY*255;

	//mountains
	cosX = id->proj.dot(x_axis);
	cosX += 1; //adjust range to 0-2
	cosX = cosX * num_mountains / 2; //adjust range to 0 - num_mountains

	first_mountain = floor(cosX);
	second_mountain = first_mountain + 1;
	if(second_mountain >= num_mountains)
		second_mountain = 0;
	
	percent = cosX - first_mountain;
	mountainHeight = (1-percent)*mountains[first_mountain] + 
			(percent)*mountains[second_mountain];
	mountainHeight = cosY - mountainHeight * projHeight;
	
	if(mountainHeight < 0)
	{
		bg->r = 75*(1+mountainHeight*5);
		bg->g = 50*(1+mountainHeight*5);
		bg->b = 0;
	}
}

extern char debug_ray;
void refract_Color(intersect_data *id, Color *outColor)
{
	intersect_data new_id;
	CHECK_STEPS(id->step, main_scene->max_recurs);
	
	//if(debug_ray)
	//	printf("debugger");

	if(id->obj->trans > 0 && (id->obj->refract_index != 0.0) ) {
		vector3 i = id->proj;
		vector3 n = id->normal;
		vector3 i_inv = i*-1;
		vector3 refract;
		Color rflColor;
		Color rfaColor;
		
		rflColor.clear();
		rfaColor.clear();
		i.normalize();
		n.normalize();
		
		float reflectAmount = id->proj.refract(refract, id->normal, id->obj->refract_index);
		
		float random = (float) rand()/RAND_MAX;
		
		//reflection
		/*
		if(0 && reflectAmount > 0.0) {
		vector3 rfl;
			reflect_vector(&rfl, &id->proj, &id->normal);
			
			fill_in_next_hit_data(&new_id, id);
			new_id.proj = rfl;
			new_id.obj_num = trace(&new_id.start, &new_id.intersect, &new_id.proj, new_id.step); 
			new_id.obj = main_scene->models[new_id.obj_num];
			new_id.obj->shader(&new_id, &rflColor);
		}
		 */
		
		//refraction
		if(reflectAmount < 1.0){			
			fill_in_next_hit_data(&new_id, id);
			new_id.proj = refract;
			//new_id.obj_num = trace(new_id.start, new_id.intersect, new_id.proj, new_id.step); 
			//new_id.obj = main_scene->models[new_id.obj_num];
			new_id.obj->shader(&new_id, &rfaColor);
		}

		//*outColor = rflColor*reflectAmount + rfaColor*(1.0-reflectAmount);
		*outColor = rfaColor;
	}
}

void shader_shadow_cost(intersect_data *id, Color *new_Color)
{
	int rays_tried;
	int i = 0;
	Color shadowed_Color;
	
	for(i=0; main_scene->lights[i]!=NULL; i++)
	{
		id->other_obj_num = i;
		get_shadow(id, &shadowed_Color);
		rays_tried = shadowed_Color.g;
		rays_tried = rays_tried*(255.0f/SHADOW_RAY_SAMPLES);
		shadowed_Color = Color(rays_tried, rays_tried, rays_tried);
		*new_Color += shadowed_Color;
	}
	
	return;
}

void reflect_Color(intersect_data *i_data, Color *new_Color)
{
	intersect_data new_id;
	//CHECK_STEPS(i_data->step, main_scene->max_recurs);
	fill_in_next_hit_data(&new_id, i_data);
	new_id.proj = i_data->proj.reflect(i_data->normal);
	Ray r(i_data->intersect, new_id.proj);
	HitPoint h;
	
	if( main_scene->hierarchy->rayIntersectAll(r, h) )
	{
		new_id.obj = h.primitivePtr;
		new_id.proj = r.getDir();
		new_id.intersect = h.pos;
		h.primitivePtr->shader(&new_id, new_Color);
	}
	else
		main_scene->background->shader(&i_data, new_Color);
}

void glossy_reflect_Color(intersect_data *i_data, Color *new_Color)
{
#define GLOSSY_SAMPLES 200
	int rays_tried;
	int check_every = 35;
	int next_check = check_every;
	float epsilon = 0.0001;
	float reflection_amount;
	float last_reflection_amount = 9999999999.0;
	Color glossy_Color, sample_Color;
vector3 perfect_reflection_dir;
	float spread =  i_data->obj->glossy;
	float half_spread = spread / 2.0;
	intersect_data new_id;
	
	CHECK_STEPS(i_data->step, main_scene->max_recurs);	

	//get reflection vector
	if(i_data->obj->reflect > 0)
		perfect_reflection_dir = i_data->proj.reflect(i_data->normal);
	else
		return;

	glossy_Color.clear();
	for(rays_tried = 1; rays_tried <= GLOSSY_SAMPLES; rays_tried++)
	{
		fill_in_next_hit_data(&new_id, i_data);
		
		//perturb the reflection
		new_id.start = vector3(i_data->intersect);
		new_id.proj = vector3(perfect_reflection_dir);
		new_id.proj.c[0] -= ((float)rand()/RAND_MAX) * spread - half_spread;
		new_id.proj.c[1] -= ((float)rand()/RAND_MAX) * spread - half_spread;
		new_id.proj.c[2] -= ((float)rand()/RAND_MAX) * spread - half_spread;
		new_id.proj.normalize();

		//intersect and shade		
		//new_id.obj_num = trace(new_id.start, new_id.intersect, new_id.proj, new_id.step);
		//new_id.obj = main_scene->models[new_id.obj_num];
		new_id.obj->shader(&new_id, &sample_Color);
		
		glossy_Color += sample_Color;
			
		if(rays_tried == next_check)
		{
			reflection_amount = (glossy_Color.r + glossy_Color.g + glossy_Color.b) / (float)rays_tried;
			if(last_reflection_amount == reflection_amount)
				break;

			if(fabs(last_reflection_amount - reflection_amount) <  epsilon)
				break;
			last_reflection_amount = reflection_amount;
			next_check += check_every;
		}
	}

	*new_Color = glossy_Color;
	*new_Color *= 1.0f/((float)(rays_tried-1));
}

void trans_Color(intersect_data *id, Color *new_Color)
{
	intersect_data new_id;

	CHECK_STEPS(id->step, main_scene->max_recurs);
	fill_in_next_hit_data(&new_id, id);

	if(id->obj->trans > 0)
	{
		new_id.start = vector3(id->intersect);
		new_id.proj = vector3(id->proj);
		
		//new_id.obj_num = trace(new_id.start, new_id.intersect, new_id.proj, new_id.step);
		//new_id.obj = main_scene->models[new_id.obj_num];
		new_id.obj->shader(&new_id, new_Color);
	}
	printd(DEBUG, "}trans_Color\n");
}

void black_white_filter(intersect_data *id, Color *new_Color)
{
	intersect_data new_id;
	float bw_Color = 0.0;

	CHECK_STEPS(id->step, main_scene->max_recurs);
	fill_in_next_hit_data(&new_id, id);
	
	new_id.start = vector3(id->intersect);
	new_id.proj = vector3(id->proj);
	new_id.start.c[0] -= id->normal.c[0]*0.01;
	new_id.start.c[1] -= id->normal.c[1]*0.01;
	new_id.start.c[2] -= id->normal.c[2]*0.01;

	//new_id.obj_num = trace(new_id.start, new_id.intersect, new_id.proj, new_id.step);
	//new_id.obj = main_scene->models[new_id.obj_num];
	new_id.obj->shader(&new_id, new_Color);

	bw_Color = new_Color->r + new_Color->g + new_Color->b;
	bw_Color = bw_Color / 3;
	new_Color->r = bw_Color;
	new_Color->g = bw_Color;
	new_Color->b = bw_Color;
}

void portal_filter(intersect_data *id, Color *new_Color)
{
	intersect_data new_id;
	vector3 bend;
	vector3 portal;

	CHECK_STEPS(id->step, main_scene->max_recurs);
	fill_in_next_hit_data(&new_id, id);
	
	portal.c[0] = id->obj->amb.r;
	portal.c[1] = id->obj->amb.g;
	portal.c[2] = id->obj->amb.b;
	
	//vector3 from portal to track point (will be new proj)
	new_id.proj = vector3(main_scene->camera->lookAtPoint, portal);
	new_id.proj.normalize();

	//next start point
	new_id.start = vector3(portal);

	//amount the current proj differs from track point vector
	bend = vector3(id->proj, main_scene->camera->look);
	bend.normalize();

	//add amount of differ to new projection
	bend = new_id.proj + bend;

	//new_id.obj_num = trace(new_id.start, new_id.intersect, new_id.proj, new_id.step);
	//new_id.obj = main_scene->models[new_id.obj_num];
	new_id.obj->shader(&new_id, new_Color);
}

void lens_filter(intersect_data *id, Color *new_Color)
{
	intersect_data new_id;
vector3 bend;
	
	CHECK_STEPS(id->step, main_scene->max_recurs);
	fill_in_next_hit_data(&new_id, id);
	
	new_id.start = vector3(id->intersect);
	new_id.proj = vector3(id->proj);
	
	bend = vector3(id->intersect, id->pos);
	bend = bend * 0.01;
	new_id.proj = new_id.proj + bend;
	 
	new_id.start.c[0] -= id->normal.c[0]*0.01;
	new_id.start.c[1] -= id->normal.c[1]*0.01;
	new_id.start.c[2] -= id->normal.c[2]*0.01;
	 
	//new_id.obj_num = trace(new_id.start, new_id.intersect, new_id.proj, new_id.step);
	//new_id.obj = main_scene->models[new_id.obj_num];
	new_id.obj->shader(&new_id, new_Color);
}

void sin_filter(intersect_data *id, Color *new_Color)
{
	intersect_data new_id;
vector3 bend;
	float dist = 0.0;

	CHECK_STEPS(id->step, main_scene->max_recurs);
	fill_in_next_hit_data(&new_id, id);
	
	new_id.start = vector3(id->intersect);
	new_id.proj = vector3(id->proj);
	
	dist = id->intersect.distance(id->obj->pos);
	bend = vector3(id->intersect, id->obj->pos);

	//bend = bend * sin(dist+current_time/TIME_SCALE);
	bend = bend * 0.2;
	new_id.proj = new_id.proj + bend;

	new_id.start.c[0] -= id->normal.c[0]*0.01;
	new_id.start.c[1] -= id->normal.c[1]*0.01;
	new_id.start.c[2] -= id->normal.c[2]*0.01;

	//new_id.obj_num = trace(new_id.start, new_id.intersect, new_id.proj, new_id.step);
	//new_id.obj = main_scene->models[new_id.obj_num];
	new_id.obj->shader(&new_id, new_Color);
}


void wire(intersect_data *i_data, Color* final_Color)
{
	//this shader probably doesn't work anymore- doesn't handle recursion data correctly
	Color new_Color;
	new_Color.r = 0;
	new_Color.g = 0;
	new_Color.b = 0;
	intersect_data new_id;
	
	CHECK_STEPS(i_data->step, main_scene->max_recurs);
	fill_in_next_hit_data(&new_id, i_data);
	
	//get_normal(i_data->intersect, i_data->obj, i_data->normal);
	i_data->normal = i_data->obj->normalAtPoint(i_data->intersect);
	i_data->normal.normalize();
	

	//shoot rays through the middle of the disc
	if(i_data->intersect.distance(i_data->obj->pos) < i_data->obj->radius - 0.06)
	{
		// move the intersection for internal Primitive calculations 
		i_data->intersect.c[0] -= i_data->normal.c[0]*0.05;
		i_data->intersect.c[1] -= i_data->normal.c[1]*0.05;
		i_data->intersect.c[2] -= i_data->normal.c[2]*0.05;
		
		// transparency
		new_Color.clear();
		final_Color->clear();
		trans_Color(i_data, &new_Color);
		*final_Color += new_Color;
		new_Color.clear();
		i_data->step--;
	}
	else  //only the edges show
	{
		// phong 
		phong(i_data, &new_Color);
		*final_Color += new_Color;

		// reflection 	
		reflect_Color(i_data, &new_Color);
		*final_Color *= (1 - i_data->obj->reflect);
		new_Color *= i_data->obj->reflect;
		*final_Color += new_Color;
		new_Color.clear();
		i_data->step--;
	}
}

void shader_template(intersect_data *hit_data_for_this_shader, Color* output_from_this_shader)
{
	intersect_data hit_data_for_next_shader;
	
	CHECK_STEPS(hit_data_for_this_shader->step, main_scene->max_recurs);
	fill_in_next_hit_data(&hit_data_for_next_shader, hit_data_for_this_shader);
}

