#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "../Primitives/PrimitiveBase.h"
#include "../common/Vector3.h"

#include "../common/scene.h"
#include "../common/debug.h"
#include "./shaders.h"
#include "./lighting.h"

extern SlimScene* main_scene;

inline float ambient_occlusion(intersect_data *hit_data)
{
#define OCCLUSION_SAMPLES 200
#define MAX_OCCL_DIS 400.0
	int rays_tried;
	int check_every = 15;
	int next_check = check_every;
	float ambientEpsilon = 0.01;
	float occlusion_amount = 0;
	float occlusion_percent = 1.0;
	float last_occlusion_percent = occlusion_percent;
vector3 occl_dir;
vector3 occl_hit;
vector3 hit_point = hit_data->intersect;

	for(rays_tried = 1; rays_tried <= OCCLUSION_SAMPLES; rays_tried++)
	{
		//perturb the normal
		occl_dir = vector3(hit_data->normal);
		occl_dir.c[0] -= ((float)rand()/RAND_MAX) * 2 - 1;
		occl_dir.c[1] -= ((float)rand()/RAND_MAX) * 2 - 1;
		occl_dir.c[2] -= ((float)rand()/RAND_MAX) * 2 - 1;
		occl_dir.normalize();

		//check distance
		//intersect_all_Primitives_getptr(hit_point, occl_dir, occl_hit);
		float occl_dis = hit_point.distance(occl_hit);
		if(occl_dis > MAX_OCCL_DIS)
			occlusion_amount += 1.0;
		else
			occlusion_amount += occl_dis/MAX_OCCL_DIS;
			
		if(rays_tried == next_check)
		{
			occlusion_percent = occlusion_amount / (float)rays_tried;
			if(last_occlusion_percent == occlusion_percent)
				return occlusion_percent;

			if(fabs(last_occlusion_percent - occlusion_percent) < ambientEpsilon)
				return occlusion_percent;
			last_occlusion_percent = occlusion_percent;
			next_check += check_every;
		}
	}

	return occlusion_amount / (float)rays_tried;
}

inline void ambient_light(Color* c, intersect_data* id, int ln)
{
	float darkener = 1;
	//vector3 uv;

	if(id->obj->obj_type == SPHERE)
	{
//		id->obj->inverse_map(&id->intersect, id->obj, &uv);
//		if((uv.c[0] > 0.25 && uv.c[1] > 0.25) || (uv.c[0] < 0.25 && uv.c[1] < 0.25))
//		if(uv.c[1] > 0.5 )
//			darkener = 0.1;
	}
	
	//darkener = ambient_occlusion(id);
	
	c->r += (id->obj->amb.r * main_scene->lights[ln]->amb.r * darkener);
	c->g += (id->obj->amb.g * main_scene->lights[ln]->amb.g * darkener);
	c->b += (id->obj->amb.b * main_scene->lights[ln]->amb.b * darkener);
}


inline void diffuse_fast(Color* c, intersect_data* id, int ln)
{
	float dpLN;
	float atten;
	float distance;
	vector3 lightV;
	
	lightV = main_scene->lights[ln]->pos - id->intersect;
	lightV.normalize();
	dpLN = lightV.dot(id->normal.normalize());
	
	// directly perpendicular/behind Primitive
	if (dpLN <= 0)
		dpLN = 0;
	
	/* light distance */
	distance = main_scene->lights[ln]->pos.distance(id->intersect);
	
	atten = 100/(50+1*distance+0.0004*pow(distance,2));
	//atten = 60/pow(distance,2);
	//atten = 3/distance;
	//atten = 0.08;
	if(main_scene->lights[ln]->obj_type == LIGHT_INFINITE)
		atten = 1;
	
	*c += (id->obj->diff * dpLN * main_scene->lights[ln]->diff * atten );
}

inline void diffuse_light(Color* c, intersect_data* id, int ln)
{
	vector3 lightV;  //vector3 to light from point q
	vector3 intersectP = vector3(id->intersect);
	//float dpLN;
	//float atten;
	//float distance;

	//float darkener = 1;
	//vector3 uv;

	/* light vector */
	lightV.c[0] = main_scene->lights[ln]->pos.c[0] - intersectP.c[0];
	lightV.c[1] = main_scene->lights[ln]->pos.c[1] - intersectP.c[1];
	lightV.c[2] = main_scene->lights[ln]->pos.c[2] - intersectP.c[2];
	lightV.normalize();

	diffuse_fast(c, id, ln);

}


inline void specular_light(Color* c, intersect_data* id, int ln)
{
vector3 lightV;  //vector to light from point q
vector3 light_refl;
	float dpLN;
	float dpCR;
	float atten;
	float spec_gamma = id->obj->spec_alpha;
	float distance;

	lightV = main_scene->lights[ln]->pos - id->intersect;
	lightV.normalize();
	dpLN = lightV.dot(id->normal.normalize());
	//invert_vector(&lightV);

	if (dpLN <= 0)
		dpLN = 0;
	// light distance
	//distance = main_scene->lights[ln]->pos.distance(id->intersect);

	//atten = 1/(50+2*distance+1.5*pow(distance,2))*80;
	//atten = 1/pow(distance,2)*80;
	///atten = 1/distance*20;
	//atten = 5/distance;
	//atten = 1;

	//light reflection vector
	light_refl = lightV.reflect(id->normal);

	id->proj.normalize();
	dpCR = id->proj.dot( light_refl);
	if(dpCR < 0)
		dpCR = 0;

	*c += (id->obj->spec * main_scene->lights[ln]->spec * pow(dpCR,spec_gamma)) * dpLN;

}


void phong(intersect_data *id, Color *new_Color)
{
//	float visible = 1;
	int i = 0;
	Color a,d,s,shadowed_Color;
	a.clear();
	d.clear();
	s.clear();
	//shadowed_Color.clear();
	
	shadowed_Color.r = 1.0f;
	
	for(i=0; main_scene->lights[i]!=NULL; i++)
	{
		ambient_light(&a, id, i);
		id->other_obj_num = i;
		get_shadow(id, &shadowed_Color);

		if ( shadowed_Color.r > 0)
		{
			diffuse_fast(&d, id, i);
			specular_light(&s, id, i);
		}
				
		d *= shadowed_Color.r;
		//multiply_Color(&s, shadowed_Color.r);
		*new_Color += a;
		*new_Color += d;
		*new_Color += s;
		//add_Colors(new_Color, &s);
	}
	//add_Colors(new_Color, &id->obj->emit);
	*new_Color *= 1.0/765.0;
	
	return;
}
