#include "../../common/buffer.h"
#include "../../common/Color.h"
#include "../shaders.h"
#include "../../parse/parser.h"
#include <stdlib.h>



int _init_blend(void **data_ptr, char *input)
{
	/*void* data = malloc(sizeof(int));
	
	if(assign_int(data, input) == 0)
	{
		free(data);
		return 0;
	}
	
	*data_ptr = (void*)data;
	 */
	return 1;
}

void _run_blend(void *data)
{
	unsigned char *front, *back;
	int x,y;
	Color old_Color;
	Color new_Color;
	
	front = main_scene->Color_front;
	back = main_scene->Color_back;
	
	for(y = 0; y < main_scene->height; y++)
	{
		for(x = 0; x < main_scene->width; x++)
		{
			get_Color(x, y, &new_Color);
			//normalize_Color(&new_Color);
			
			main_scene->Color_front = back;
			get_Color(x, y, &old_Color);
			set_Color(x, y, &new_Color);
			
			main_scene->Color_front = front;
			new_Color = new_Color * 0.8 + old_Color * 0.4;
			///			if(x == 100)
			//				print_Color(123, "", &new_Color);
			//normalize_Color(&new_Color);
			set_Color(x, y, &new_Color);
		}
	}
}


void _cleanup_blend(void* data)
{
	//free((int*)data);
}


shader_data blend =
{
	"blend",
	"options:\n   blend\n",
	(int (*)(void*, char*))_init_blend,
	(void* (*)(void*))_run_blend,
	(void* (*)(void*))_cleanup_blend,
};

shader_data* get_blend()
{
	return &blend;
}
