#include "../../common/buffer.h"
#include "../../common/Color.h"
#include "../shaders.h"
#include "../../parse/parser.h"
#include <stdlib.h>

char *help = 
"options:\n\
   convolve <int blursize>\n";
   
int _init_blur(void **data_ptr, char *input)
{
	void* data = malloc(sizeof(int));
	
	if(assign_int(data, input) == 0)
	{
		free(data);
		return 0;
	}
	
	*data_ptr = (void*)data;
	return 1;
}

void _run_blur(void *data)
{
	int i, x, y;
	Color blur_Color, temp_Color;
	unsigned char *fb, *bb;
	int k_size;
	
	k_size = *(int*)data;

	fb = main_scene->Color_front;
	bb = main_scene->Color_back;
	
	for(y = k_size; y < main_scene->height - k_size; y++)
	{
		for(x = k_size; x < main_scene->width - k_size; x++)
		{
			main_scene->Color_front = fb;

			int xx=0;
			for(i = -k_size; i <= k_size; i++)
			{
				get_Color(x+i, y, &temp_Color);
				blur_Color += temp_Color;
				xx++;
			}

			for(i = -k_size; i <= k_size; i++)
			{
				get_Color(x, y+i, &temp_Color);
				blur_Color += temp_Color;
				xx++;
			}

			//normalize
			blur_Color *= 1.0/(2*(2*k_size +1));
			//multiply_Color(&blur_Color, 1/xx);

			main_scene->Color_front = bb;
			set_Color(x, y, &blur_Color);
			blur_Color.clear();
		}
	}

	main_scene->Color_front = bb;
	main_scene->Color_back = fb;
}


void _cleanup_blur(void* data)
{
	free((int*)data);
}


shader_data blur =
{
	"blur",
	"options:\n   blur <int blursize>\n",
	(int (*)(void*, char*))_init_blur,
	(void* (*)(void*))_run_blur,
	(void* (*)(void*))_cleanup_blur,
};

shader_data* get_blur()
{
	return &blur;
}
