#include "../../common/buffer.h"
#include "../../common/Color.h"
#include "../../common/Matrix.h"
#include "../shaders.h"
#include "../../parse/parser.h"
#include <stdlib.h>
#include <string.h>

int _init_convolve(void **data_ptr, char *input)
{
	//dmatrix *matrix = (dmatrix*) malloc(sizeof(dmatrix));
	SimpleMatrix<slimFloat> *matrix;
	matrix = new SimpleMatrix<slimFloat>();

	//if(assign_dmatrix(matrix, input) == 0)
	if(assign_simple_matrix_float(matrix, input) == 0)
	{
		free(matrix);
		return 0;
	}

	*data_ptr = (void*)matrix;
	return 1;
}

void _run_convolve(void *data)
{
	int i, j, x, y;
	Color blur_Color, temp_Color;
	unsigned char *fb, *bb;
	float scale = 0;
	int horz;

	int width;
	int height;
	//slimFloat *elements;
	SimpleMatrix<slimFloat> *conv;

	conv = (SimpleMatrix<slimFloat>*)data;
	width = conv->getWidth();
	height = conv->getHeight();
	//elements = conv->elements;
	horz = (width - 1) / 2;

	scale = conv->getElementSum();
//	for(i=0; i<width*height; i++)
//			scale += elements[i];
	if(scale < 1)
		scale = 1;
	else
		scale = 1/scale;

	fb = main_scene->Color_front;
	bb = main_scene->Color_back;

	for(y = 0; y < main_scene->height - height; y++)
	{
		for(x = horz+1; x < main_scene->width - width; x++)
		{
			//apply the convolution matrix
			main_scene->Color_front = fb;
			for(int row=0; row<height; row++)
			{
				for(int col=0; col<width; col++)
				{
					get_Color(x+col, y+row, &temp_Color);
					//temp_Color *= elements[j*height+i];
					float tmpFlt = conv->getValue(row, col);
					temp_Color *= tmpFlt;
					blur_Color += temp_Color;
				}
			}

			//normalize
			blur_Color *= scale;

			main_scene->Color_front = bb;
			set_Color(x+width, y+height, &blur_Color);
			blur_Color.clear();
		}
	}
 
	main_scene->Color_front = bb;
	main_scene->Color_back = fb;
}


void _cleanup_convolve(void* data)
{
	//free(((dmatrix*)data)->elements);
	//free((dmatrix*)data);
	
	delete (SimpleMatrix<slimFloat>*) data;
}


shader_data convolve =
{
	"convolve",
	"options:\n   convolve <matrix convolution>\n",
	(int (*)(void*, char*))_init_convolve,
	(void* (*)(void*))_run_convolve,
	(void* (*)(void*))_cleanup_convolve,
};

shader_data* get_convolve()
{
	return &convolve;
}

