#include "../../common/buffer.h"
#include "../../common/Color.h"
#include "../../parse/parser.h"
#include "../shaders.h"
#include <stdlib.h>

int _init_hilight(void **data_ptr, char *input)
{
	void* data = malloc(sizeof(int));
	
	if(assign_int(data, input) == 0)
	{
		free(data);
		return 0;
	}
	
	*data_ptr = (void*)data;
	return 1;
}

void _run_hilight(void *data)
{
	static int num;
	static unsigned char *frame;
	static intersect_data *buffer;
	static intersect_data *idata;
	static Color c;
	static int x,y;

	num = *(int*)data;
	buffer = main_scene->intersect_front;
	frame = main_scene->Color_front;

	for(y = 0; y < main_scene->height; y++)
	{
		for(x = 0; x < main_scene->width; x++)
		{
			idata = get_idata(x, y);
			
			if(idata->obj_num != num)
			{
				get_Color(x, y, &c);
				c *= 0.25;
				set_Color(x, y, &c);
			}
		}
	}
}

void _cleanup_hilight(void* data)
{
	free((int*)data);
}


shader_data hilight =
{
	"hilight",
	"options:\n   hilight <int objnum>\n",
	(int (*)(void*, char*))_init_hilight,
	(void* (*)(void*))_run_hilight,
	(void* (*)(void*))_cleanup_hilight,
};

shader_data* get_hilight()
{
	return &hilight;
}


